package water.bindings.pojos;

import com.google.gson.Gson;
public class NetworkEvent extends EventV3 {
    /** Boolean flag distinguishing between sends (true) and receives(false) */
    public boolean is_send;

    /** network protocol (UDP/TCP) */
    public String protocol;

    /** UDP type (exec,ack, ackack,... */
    public String msg_type;

    /** Sending node */
    public String from;

    /** Receiving node */
    public String to;

    /** Pretty print of the first few bytes of the msg payload. Contains class name for tasks. */
    public String data;

    /* INHERITED: Time when the event was recorded. Format is hh:mm:ss:ms 
     * public String date;
     */

    /* INHERITED: Time in nanos 
     * public long nanos;
     */

    /* INHERITED: type of recorded event 
     * public EventType type;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
