package water.bindings.pojos;

import com.google.gson.Gson;
import java.util.Map;

public class PCAModelOutputV3 extends ModelOutputSchema {
    /** Standard deviation and importance of each principal component */
    public TwoDimTableV3 importance;

    /** Principal components matrix */
    public TwoDimTableV3 eigenvectors;

    /** Final value of GLRM squared loss function */
    public double objective;

    /* INHERITED: Column names 
     * public String[] names;
     */

    /* INHERITED: Domains for categorical columns 
     * public String[][] domains;
     */

    /* INHERITED: Cross-validation models (model ids) 
     * public ModelKeyV3[] cross_validation_models;
     */

    /* INHERITED: Cross-validation predictions, one per cv model (deprecated, use cross_validation_holdout_predictions_frame_id instead) 
     * public FrameKeyV3[] cross_validation_predictions;
     */

    /* INHERITED: Cross-validation holdout predictions (full out-of-sample predictions on training data) 
     * public FrameKeyV3 cross_validation_holdout_predictions_frame_id;
     */

    /* INHERITED: Cross-validation fold assignment (each row is assigned to one holdout fold) 
     * public FrameKeyV3 cross_validation_fold_assignment_frame_id;
     */

    /* INHERITED: Category of the model (e.g., Binomial) 
     * public ModelCategory model_category;
     */

    /* INHERITED: Model summary 
     * public TwoDimTableV3 model_summary;
     */

    /* INHERITED: Scoring history 
     * public TwoDimTableV3 scoring_history;
     */

    /* INHERITED: Training data model metrics 
     * public ModelMetricsBase training_metrics;
     */

    /* INHERITED: Validation data model metrics 
     * public ModelMetricsBase validation_metrics;
     */

    /* INHERITED: Cross-validation model metrics 
     * public ModelMetricsBase cross_validation_metrics;
     */

    /* INHERITED: Cross-validation model metrics summary 
     * public TwoDimTableV3 cross_validation_metrics_summary;
     */

    /* INHERITED: Job status 
     * public String status;
     */

    /* INHERITED: Start time in milliseconds 
     * public long start_time;
     */

    /* INHERITED: End time in milliseconds 
     * public long end_time;
     */

    /* INHERITED: Runtime in milliseconds 
     * public long run_time;
     */

    /* INHERITED: Help information for output fields 
     * public Map<String,String> help;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
