package water.bindings.pojos;

import com.google.gson.Gson;
public class SharedTreeParametersV3 extends ModelParametersSchema {
    /** Balance training data class counts via over/under-sampling (for imbalanced data). */
    public boolean balance_classes;

    /** Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes. */
    public float[] class_sampling_factors;

    /** Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes. */
    public float max_after_balance_size;

    /** Maximum size (# classes) for confusion matrices to be printed in the Logs */
    public int max_confusion_matrix_size;

    /** Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable) */
    public int max_hit_ratio_k;

    /** Number of trees. */
    public int ntrees;

    /** Maximum tree depth. */
    public int max_depth;

    /** Fewest allowed (weighted) observations in a leaf (in R called 'nodesize'). */
    public double min_rows;

    /** For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the best point */
    public int nbins;

    /** For numerical columns (real/int), build a histogram of (at most) this many bins at the root level, then decrease by factor of two per level */
    public int nbins_top_level;

    /** For categorical columns (factors), build a histogram of this many bins, then split at the best point. Higher values can lead to more overfitting. */
    public int nbins_cats;

    /** Stop making trees when the R^2 metric equals or exceeds this */
    public double r2_stopping;

    /** Seed for pseudo random number generator (if applicable) */
    public long seed;

    /** Run on one node only; no network overhead but fewer cpus used.  Suitable for small datasets. */
    public boolean build_tree_one_node;

    /** Row sample rate per tree (from 0.0 to 1.0) */
    public float sample_rate;

    /** Row sample rate per tree per class (from 0.0 to 1.0) */
    public float[] sample_rate_per_class;

    /** Column sample rate per tree (from 0.0 to 1.0) */
    public float col_sample_rate_per_tree;

    /** Score the model after every so many trees. Disabled if set to 0. */
    public int score_tree_interval;

    /** Minimum relative improvement in squared error reduction for a split to happen. */
    public double min_split_improvement;

    /* INHERITED: Destination id for this model; auto-generated if not specified 
     * public ModelKeyV3 model_id;
     */

    /* INHERITED: Training frame 
     * public FrameKeyV3 training_frame;
     */

    /* INHERITED: Validation frame 
     * public FrameKeyV3 validation_frame;
     */

    /* INHERITED: Number of folds for N-fold cross-validation 
     * public int nfolds;
     */

    /* INHERITED: Keep cross-validation model predictions 
     * public boolean keep_cross_validation_predictions;
     */

    /* INHERITED: Keep cross-validation fold assignment 
     * public boolean keep_cross_validation_fold_assignment;
     */

    /* INHERITED: Allow parallel training of cross-validation models 
     * public boolean parallelize_cross_validation;
     */

    /* INHERITED: Response column 
     * public ColSpecifierV3 response_column;
     */

    /* INHERITED: Column with observation weights 
     * public ColSpecifierV3 weights_column;
     */

    /* INHERITED: Offset column 
     * public ColSpecifierV3 offset_column;
     */

    /* INHERITED: Column with cross-validation fold index assignment per observation 
     * public ColSpecifierV3 fold_column;
     */

    /* INHERITED: Cross-validation fold assignment scheme, if fold_column is not specified 
     * public FoldAssignmentScheme fold_assignment;
     */

    /* INHERITED: Ignored columns 
     * public String[] ignored_columns;
     */

    /* INHERITED: Ignore constant columns 
     * public boolean ignore_const_cols;
     */

    /* INHERITED: Whether to score during each iteration of model training 
     * public boolean score_each_iteration;
     */

    /* INHERITED: Model checkpoint to resume training with 
     * public ModelKeyV3 checkpoint;
     */

    /* INHERITED: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) 
     * public int stopping_rounds;
     */

    /* INHERITED: Maximum allowed runtime in seconds for model training. Use 0 to disable. 
     * public double max_runtime_secs;
     */

    /* INHERITED: Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) 
     * public StoppingMetric stopping_metric;
     */

    /* INHERITED: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) 
     * public double stopping_tolerance;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
