package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Grid {
    /** Run grid search for DeepLearning model. */
    @FormUrlEncoded
    @POST("/99/Grid/deeplearning")
    Call<GridSearchSchema> train_deeplearning(@Field("parameters") ModelParametersSchema parameters,
                                              @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                              @Field("grid_id") String grid_id,
                                              @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);

    /** Run grid search for GLM model. */
    @FormUrlEncoded
    @POST("/99/Grid/glm")
    Call<GridSearchSchema> train_glm(@Field("parameters") ModelParametersSchema parameters,
                                     @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                     @Field("grid_id") String grid_id,
                                     @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);

    /** Run grid search for GLRM model. */
    @FormUrlEncoded
    @POST("/99/Grid/glrm")
    Call<GridSearchSchema> train_glrm(@Field("parameters") ModelParametersSchema parameters,
                                      @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                      @Field("grid_id") String grid_id,
                                      @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);

    /** Run grid search for KMeans model. */
    @FormUrlEncoded
    @POST("/99/Grid/kmeans")
    Call<GridSearchSchema> train_kmeans(@Field("parameters") ModelParametersSchema parameters,
                                        @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                        @Field("grid_id") String grid_id,
                                        @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);

    /** Run grid search for NaiveBayes model. */
    @FormUrlEncoded
    @POST("/99/Grid/naivebayes")
    Call<GridSearchSchema> train_naivebayes(@Field("parameters") ModelParametersSchema parameters,
                                            @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                            @Field("grid_id") String grid_id,
                                            @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);

    /** Run grid search for PCA model. */
    @FormUrlEncoded
    @POST("/99/Grid/pca")
    Call<GridSearchSchema> train_pca(@Field("parameters") ModelParametersSchema parameters,
                                     @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                     @Field("grid_id") String grid_id,
                                     @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);

    /** Run grid search for SVD model. */
    @FormUrlEncoded
    @POST("/99/Grid/svd")
    Call<GridSearchSchema> train_svd(@Field("parameters") ModelParametersSchema parameters,
                                     @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                     @Field("grid_id") String grid_id,
                                     @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);

    /** Run grid search for DRF model. */
    @FormUrlEncoded
    @POST("/99/Grid/drf")
    Call<GridSearchSchema> train_drf(@Field("parameters") ModelParametersSchema parameters,
                                     @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                     @Field("grid_id") String grid_id,
                                     @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);

    /** Run grid search for GBM model. */
    @FormUrlEncoded
    @POST("/99/Grid/gbm")
    Call<GridSearchSchema> train_gbm(@Field("parameters") ModelParametersSchema parameters,
                                     @Field("hyper_parameters") Map<Object,Object> hyper_parameters,
                                     @Field("grid_id") String grid_id,
                                     @Field("search_criteria") HyperSpaceSearchCriteriaV99 search_criteria);
}
