package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface ModelBuilders {
    /** Return a new unique model_id for the specified algorithm. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/{algo}/model_id")
    Call<ModelIdV3> calcModelId(@Path("algo") String algo,
                                @Field("_exclude_fields") String _exclude_fields);

    /** Return the Model Builder metadata for the specified algorithm. */
    @GET("/3/ModelBuilders/{algo}")
    Call<ModelBuildersV3> fetch(@Path("algo") String algo);

    /** Return the Model Builder metadata for all available algorithms. */
    @GET("/3/ModelBuilders")
    Call<ModelBuildersV3> list();

    /** Train a DeepLearning model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/deeplearning")
    Call<ModelBuilderSchema> train_deeplearning(@Field("parameters") ModelParametersSchema parameters,
                                                @Field("__http_status") int __http_status,
                                                @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of DeepLearning model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/deeplearning/parameters")
    Call<ModelBuilderSchema> validate_parameters_deeplearning(@Field("parameters") ModelParametersSchema parameters,
                                                              @Field("__http_status") int __http_status,
                                                              @Field("_exclude_fields") String _exclude_fields);

    /** Train a GLM model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/glm")
    Call<ModelBuilderSchema> train_glm(@Field("parameters") ModelParametersSchema parameters,
                                       @Field("__http_status") int __http_status,
                                       @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of GLM model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/glm/parameters")
    Call<ModelBuilderSchema> validate_parameters_glm(@Field("parameters") ModelParametersSchema parameters,
                                                     @Field("__http_status") int __http_status,
                                                     @Field("_exclude_fields") String _exclude_fields);

    /** Train a GLRM model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/glrm")
    Call<ModelBuilderSchema> train_glrm(@Field("parameters") ModelParametersSchema parameters,
                                        @Field("__http_status") int __http_status,
                                        @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of GLRM model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/glrm/parameters")
    Call<ModelBuilderSchema> validate_parameters_glrm(@Field("parameters") ModelParametersSchema parameters,
                                                      @Field("__http_status") int __http_status,
                                                      @Field("_exclude_fields") String _exclude_fields);

    /** Train a KMeans model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/kmeans")
    Call<ModelBuilderSchema> train_kmeans(@Field("parameters") ModelParametersSchema parameters,
                                          @Field("__http_status") int __http_status,
                                          @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of KMeans model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/kmeans/parameters")
    Call<ModelBuilderSchema> validate_parameters_kmeans(@Field("parameters") ModelParametersSchema parameters,
                                                        @Field("__http_status") int __http_status,
                                                        @Field("_exclude_fields") String _exclude_fields);

    /** Train a NaiveBayes model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/naivebayes")
    Call<ModelBuilderSchema> train_naivebayes(@Field("parameters") ModelParametersSchema parameters,
                                              @Field("__http_status") int __http_status,
                                              @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of NaiveBayes model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/naivebayes/parameters")
    Call<ModelBuilderSchema> validate_parameters_naivebayes(@Field("parameters") ModelParametersSchema parameters,
                                                            @Field("__http_status") int __http_status,
                                                            @Field("_exclude_fields") String _exclude_fields);

    /** Train a PCA model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/pca")
    Call<ModelBuilderSchema> train_pca(@Field("parameters") ModelParametersSchema parameters,
                                       @Field("__http_status") int __http_status,
                                       @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of PCA model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/pca/parameters")
    Call<ModelBuilderSchema> validate_parameters_pca(@Field("parameters") ModelParametersSchema parameters,
                                                     @Field("__http_status") int __http_status,
                                                     @Field("_exclude_fields") String _exclude_fields);

    /** Train a SVD model. */
    @FormUrlEncoded
    @POST("/99/ModelBuilders/svd")
    Call<ModelBuilderSchema> train_svd(@Field("parameters") ModelParametersSchema parameters,
                                       @Field("__http_status") int __http_status,
                                       @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of SVD model builder parameters. */
    @FormUrlEncoded
    @POST("/99/ModelBuilders/svd/parameters")
    Call<ModelBuilderSchema> validate_parameters_svd(@Field("parameters") ModelParametersSchema parameters,
                                                     @Field("__http_status") int __http_status,
                                                     @Field("_exclude_fields") String _exclude_fields);

    /** Train a DRF model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/drf")
    Call<ModelBuilderSchema> train_drf(@Field("parameters") ModelParametersSchema parameters,
                                       @Field("__http_status") int __http_status,
                                       @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of DRF model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/drf/parameters")
    Call<ModelBuilderSchema> validate_parameters_drf(@Field("parameters") ModelParametersSchema parameters,
                                                     @Field("__http_status") int __http_status,
                                                     @Field("_exclude_fields") String _exclude_fields);

    /** Train a GBM model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/gbm")
    Call<ModelBuilderSchema> train_gbm(@Field("parameters") ModelParametersSchema parameters,
                                       @Field("__http_status") int __http_status,
                                       @Field("_exclude_fields") String _exclude_fields);

    /** Validate a set of GBM model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/gbm/parameters")
    Call<ModelBuilderSchema> validate_parameters_gbm(@Field("parameters") ModelParametersSchema parameters,
                                                     @Field("__http_status") int __http_status,
                                                     @Field("_exclude_fields") String _exclude_fields);
}
