package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Parse {
    /** Parse a raw byte-oriented Frame into a useful columnar data Frame. */
    @FormUrlEncoded
    @POST("/3/Parse")
    Call<ParseV3> parse(@Field("destination_frame") String destination_frame,
                        @Field("source_frames") FrameKeyV3[] source_frames,
                        @Field("parse_type") ParserType parse_type,
                        @Field("separator") byte separator,
                        @Field("single_quotes") boolean single_quotes,
                        @Field("check_header") int check_header,
                        @Field("number_columns") int number_columns,
                        @Field("column_names") String[] column_names,
                        @Field("column_types") String[] column_types,
                        @Field("domains") String[][] domains,
                        @Field("na_strings") String[][] na_strings,
                        @Field("chunk_size") int chunk_size,
                        @Field("delete_on_done") boolean delete_on_done,
                        @Field("blocking") boolean blocking,
                        @Field("_exclude_fields") String _exclude_fields);
}
