package water.bindings.pojos;

import com.google.gson.Gson;

public class CreateFrameV3 extends RequestSchema {
    /** destination key */
    public FrameKeyV3 dest;

    /** Number of rows */
    public long rows;

    /** Number of data columns (in addition to the first response column) */
    public int cols;

    /** Random number seed that determines the random values */
    public long seed;

    /** Random number seed for setting the column types */
    public long seed_for_column_types;

    /** Whether frame should be randomized */
    public boolean randomize;

    /** Constant value (for randomize=false) */
    public long value;

    /** Range for real variables (-range ... range) */
    public long real_range;

    /** Fraction of categorical columns (for randomize=true) */
    public double categorical_fraction;

    /** Factor levels for categorical variables */
    public int factors;

    /** Fraction of integer columns (for randomize=true) */
    public double integer_fraction;

    /** Range for integer variables (-range ... range) */
    public long integer_range;

    /** Fraction of binary columns (for randomize=true) */
    public double binary_fraction;

    /** Fraction of 1's in binary columns */
    public double binary_ones_fraction;

    /** Fraction of date/time columns (for randomize=true) */
    public double time_fraction;

    /** Fraction of string columns (for randomize=true) */
    public double string_fraction;

    /** Fraction of missing values */
    public double missing_fraction;

    /** Number of factor levels of the first column (1=real, 2=binomial, N=multinomial) */
    public int response_factors;

    /** Whether an additional response column should be generated */
    public boolean has_response;

    /** Job Key */
    public JobKeyV3 key;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public CreateFrameV3() {
        dest = null;
        rows = 10000L;
        cols = 10;
        seed = -8663034988219277644L;
        seed_for_column_types = -1L;
        randomize = true;
        value = 0L;
        real_range = 100L;
        categorical_fraction = 0.2;
        factors = 100;
        integer_fraction = 0.2;
        integer_range = 100L;
        binary_fraction = 0.1;
        binary_ones_fraction = 0.02;
        time_fraction = 0.0;
        string_fraction = 0.0;
        missing_fraction = 0.01;
        response_factors = 2;
        has_response = false;
        key = null;
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
