package water.bindings.pojos;

import com.google.gson.Gson;

public class DeepLearningParametersV3 extends ModelParametersSchema {
    /** Balance training data class counts via over/under-sampling (for imbalanced data). */
    public boolean balance_classes;

    /** Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes. */
    public float[] class_sampling_factors;

    /** Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes. */
    public float max_after_balance_size;

    /** Maximum size (# classes) for confusion matrices to be printed in the Logs */
    public int max_confusion_matrix_size;

    /** Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable) */
    public int max_hit_ratio_k;

    /** If enabled, override the final model with the best model found during training */
    public boolean overwrite_with_best_model;

    /** Auto-Encoder */
    public boolean autoencoder;

    /** Use all factor levels of categorical variables. Otherwise, the first factor level is omitted (without loss of accuracy). Useful for variable importances and auto-enabled for autoencoder. */
    public boolean use_all_factor_levels;

    /** If enabled, automatically standardize the data. If disabled, the user must provide properly scaled input data. */
    public boolean standardize;

    /** Activation function */
    public DeeplearningDeepLearningModelDeepLearningParametersActivation activation;

    /** Hidden layer sizes (e.g. 100,100). */
    public int[] hidden;

    /** How many times the dataset should be iterated (streamed), can be fractional */
    public double epochs;

    /** Number of training samples (globally) per MapReduce iteration. Special values are 0: one epoch, -1: all available data (e.g., replicated training data), -2: automatic */
    public long train_samples_per_iteration;

    /** Target ratio of communication overhead to computation. Only for multi-node operation and train_samples_per_iteration=-2 (auto-tuning) */
    public double target_ratio_comm_to_comp;

    /** Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded */
    public long seed;

    /** Adaptive learning rate */
    public boolean adaptive_rate;

    /** Adaptive learning rate time decay factor (similarity to prior updates) */
    public double rho;

    /** Adaptive learning rate smoothing factor (to avoid divisions by zero and allow progress) */
    public double epsilon;

    /** Learning rate (higher => less stable, lower => slower convergence) */
    public double rate;

    /** Learning rate annealing: rate / (1 + rate_annealing * samples) */
    public double rate_annealing;

    /** Learning rate decay factor between layers (N-th layer: rate*alpha^(N-1)) */
    public double rate_decay;

    /** Initial momentum at the beginning of training (try 0.5) */
    public double momentum_start;

    /** Number of training samples for which momentum increases */
    public double momentum_ramp;

    /** Final momentum after the ramp is over (try 0.99) */
    public double momentum_stable;

    /** Use Nesterov accelerated gradient (recommended) */
    public boolean nesterov_accelerated_gradient;

    /** Input layer dropout ratio (can improve generalization, try 0.1 or 0.2) */
    public double input_dropout_ratio;

    /** Hidden layer dropout ratios (can improve generalization), specify one value per hidden layer, defaults to 0.5 */
    public double[] hidden_dropout_ratios;

    /** L1 regularization (can add stability and improve generalization, causes many weights to become 0) */
    public double l1;

    /** L2 regularization (can add stability and improve generalization, causes many weights to be small */
    public double l2;

    /** Constraint for squared sum of incoming weights per unit (e.g. for Rectifier) */
    public float max_w2;

    /** Initial Weight Distribution */
    public DeeplearningDeepLearningModelDeepLearningParametersInitialWeightDistribution initial_weight_distribution;

    /** Uniform: -value...value, Normal: stddev) */
    public double initial_weight_scale;

    /** A list of H2OFrame ids to initialize the weight matrices of this model with. */
    public FrameKeyV3[] initial_weights;

    /** A list of H2OFrame ids to initialize the bias vectors of this model with. */
    public FrameKeyV3[] initial_biases;

    /** Loss function */
    public DeeplearningDeepLearningModelDeepLearningParametersLoss loss;

    /** Distribution function */
    public DistributionFamily distribution;

    /** Tweedie Power */
    public double tweedie_power;

    /** Desired quantile for quantile regression (from 0.0 to 1.0) */
    public double quantile_alpha;

    /** Shortest time interval (in secs) between model scoring */
    public double score_interval;

    /** Number of training set samples for scoring (0 for all) */
    public long score_training_samples;

    /** Number of validation set samples for scoring (0 for all) */
    public long score_validation_samples;

    /** Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring). */
    public double score_duty_cycle;

    /** Stopping criterion for classification error fraction on training data (-1 to disable) */
    public double classification_stop;

    /** Stopping criterion for regression error (MSE) on training data (-1 to disable) */
    public double regression_stop;

    /** Enable quiet mode for less output to standard output */
    public boolean quiet_mode;

    /** Method used to sample validation dataset for scoring */
    public DeeplearningDeepLearningModelDeepLearningParametersClassSamplingMethod score_validation_sampling;

    /** Enable diagnostics for hidden layers */
    public boolean diagnostics;

    /** Compute variable importances for input features (Gedeon method) - can be slow for large networks */
    public boolean variable_importances;

    /** Enable fast mode (minor approximation in back-propagation) */
    public boolean fast_mode;

    /** Force extra load balancing to increase training speed for small datasets (to keep all cores busy) */
    public boolean force_load_balance;

    /** Replicate the entire training dataset onto every node for faster training on small datasets */
    public boolean replicate_training_data;

    /** Run on a single node for fine-tuning of model parameters */
    public boolean single_node_mode;

    /** Enable shuffling of training data (recommended if training data is replicated and train_samples_per_iteration is close to #nodes x #rows, of if using balance_classes) */
    public boolean shuffle_training_data;

    /** Handling of missing values. Either Skip or MeanImputation. */
    public DeeplearningDeepLearningModelDeepLearningParametersMissingValuesHandling missing_values_handling;

    /** Sparse data handling (more efficient for data with lots of 0 values). */
    public boolean sparse;

    /** Use a column major weight matrix for input layer. Can speed up forward propagation, but might slow down backpropagation (Deprecated). */
    public boolean col_major;

    /** Average activation for sparse auto-encoder (Experimental) */
    public double average_activation;

    /** Sparsity regularization (Experimental) */
    public double sparsity_beta;

    /** Max. number of categorical features, enforced via hashing (Experimental) */
    public int max_categorical_features;

    /** Force reproducibility on small data (will be slow - only uses 1 thread) */
    public boolean reproducible;

    /** Whether to export Neural Network weights and biases to H2O Frames */
    public boolean export_weights_and_biases;

    /** Mini-batch size (smaller leads to better fit, larger can speed up and generalize better) */
    public int mini_batch_size;

    /** Elastic averaging between compute nodes can improve distributed model convergence (Experimental) */
    public boolean elastic_averaging;

    /** Elastic averaging moving rate (only if elastic averaging is enabled). */
    public double elastic_averaging_moving_rate;

    /** Elastic averaging regularization strength (only if elastic averaging is enabled). */
    public double elastic_averaging_regularization;

    /** Pretrained autoencoder model to initialize this model with. */
    public ModelKeyV3 pretrained_autoencoder;

    /* INHERITED: Destination id for this model; auto-generated if not specified 
    public ModelKeyV3 model_id = null;
     */

    /* INHERITED: Training frame 
    public FrameKeyV3 training_frame = null;
     */

    /* INHERITED: Validation frame 
    public FrameKeyV3 validation_frame = null;
     */

    /* INHERITED: Number of folds for N-fold cross-validation 
    public int nfolds = 0;
     */

    /* INHERITED: Keep cross-validation model predictions 
    public boolean keep_cross_validation_predictions = false;
     */

    /* INHERITED: Keep cross-validation fold assignment 
    public boolean keep_cross_validation_fold_assignment = false;
     */

    /* INHERITED: Allow parallel training of cross-validation models 
    public boolean parallelize_cross_validation = true;
     */

    /* INHERITED: Response column 
    public ColSpecifierV3 response_column = null;
     */

    /* INHERITED: Column with observation weights 
    public ColSpecifierV3 weights_column = null;
     */

    /* INHERITED: Offset column 
    public ColSpecifierV3 offset_column = null;
     */

    /* INHERITED: Column with cross-validation fold index assignment per observation 
    public ColSpecifierV3 fold_column = null;
     */

    /* INHERITED: Cross-validation fold assignment scheme, if fold_column is not specified 
    public ModelParametersFoldAssignmentScheme fold_assignment = ModelParametersFoldAssignmentScheme.AUTO;
     */

    /* INHERITED: Ignored columns 
    public String[] ignored_columns = null;
     */

    /* INHERITED: Ignore constant columns 
    public boolean ignore_const_cols = true;
     */

    /* INHERITED: Whether to score during each iteration of model training 
    public boolean score_each_iteration = false;
     */

    /* INHERITED: Model checkpoint to resume training with 
    public ModelKeyV3 checkpoint = null;
     */

    /* INHERITED: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) 
    public int stopping_rounds = 5;
     */

    /* INHERITED: Maximum allowed runtime in seconds for model training. Use 0 to disable. 
    public double max_runtime_secs = 0.0;
     */

    /* INHERITED: Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) 
    public ScoreKeeperStoppingMetric stopping_metric = ScoreKeeperStoppingMetric.AUTO;
     */

    /* INHERITED: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) 
    public double stopping_tolerance = 0.0;
     */

    public DeepLearningParametersV3() {
        balance_classes = false;
        class_sampling_factors = null;
        max_after_balance_size = 5.0f;
        max_confusion_matrix_size = 20;
        max_hit_ratio_k = 0;
        overwrite_with_best_model = true;
        autoencoder = false;
        use_all_factor_levels = true;
        standardize = true;
        activation = DeeplearningDeepLearningModelDeepLearningParametersActivation.Rectifier;
        hidden = new int[]{200, 200};
        epochs = 10.0;
        train_samples_per_iteration = -2L;
        target_ratio_comm_to_comp = 0.05;
        seed = 2778520870660787013L;
        adaptive_rate = true;
        rho = 0.99;
        epsilon = 1e-08;
        rate = 0.005;
        rate_annealing = 1e-06;
        rate_decay = 1.0;
        momentum_start = 0.0;
        momentum_ramp = 1000000.0;
        momentum_stable = 0.0;
        nesterov_accelerated_gradient = true;
        input_dropout_ratio = 0.0;
        hidden_dropout_ratios = null;
        l1 = 0.0;
        l2 = 0.0;
        max_w2 = Float.POSITIVE_INFINITY;
        initial_weight_distribution = DeeplearningDeepLearningModelDeepLearningParametersInitialWeightDistribution.UniformAdaptive;
        initial_weight_scale = 1.0;
        initial_weights = null;
        initial_biases = null;
        loss = DeeplearningDeepLearningModelDeepLearningParametersLoss.Automatic;
        distribution = DistributionFamily.AUTO;
        tweedie_power = 1.5;
        quantile_alpha = 0.5;
        score_interval = 5.0;
        score_training_samples = 10000L;
        score_validation_samples = 0L;
        score_duty_cycle = 0.1;
        classification_stop = 0.0;
        regression_stop = 1e-06;
        quiet_mode = false;
        score_validation_sampling = DeeplearningDeepLearningModelDeepLearningParametersClassSamplingMethod.Uniform;
        diagnostics = true;
        variable_importances = false;
        fast_mode = true;
        force_load_balance = true;
        replicate_training_data = true;
        single_node_mode = false;
        shuffle_training_data = false;
        missing_values_handling = DeeplearningDeepLearningModelDeepLearningParametersMissingValuesHandling.MeanImputation;
        sparse = false;
        col_major = false;
        average_activation = 0.0;
        sparsity_beta = 0.0;
        max_categorical_features = 2147483647;
        reproducible = false;
        export_weights_and_biases = false;
        mini_batch_size = 1;
        elastic_averaging = false;
        elastic_averaging_moving_rate = 0.9;
        elastic_averaging_regularization = 0.001;
        pretrained_autoencoder = null;
        model_id = null;
        training_frame = null;
        validation_frame = null;
        nfolds = 0;
        keep_cross_validation_predictions = false;
        keep_cross_validation_fold_assignment = false;
        parallelize_cross_validation = true;
        response_column = null;
        weights_column = null;
        offset_column = null;
        fold_column = null;
        fold_assignment = ModelParametersFoldAssignmentScheme.AUTO;
        ignored_columns = null;
        ignore_const_cols = true;
        score_each_iteration = false;
        checkpoint = null;
        stopping_rounds = 5;
        max_runtime_secs = 0.0;
        stopping_metric = ScoreKeeperStoppingMetric.AUTO;
        stopping_tolerance = 0.0;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
