package water.bindings.pojos;

import com.google.gson.Gson;

public class FieldMetadataV3 extends FieldMetadataBase {
    /* INHERITED: Field name in the Schema 
    public String name = "";
     */

    /* INHERITED: Type for this field 
    public String type = "";
     */

    /* INHERITED: Type for this field is itself a Schema. 
    public boolean is_schema = false;
     */

    /* INHERITED: Schema name for this field, if it is_schema, or the name of the enum, if it's an enum. 
    public String schema_name = "";
     */

    /* INHERITED: Value for this field 
    public Object value = null;
     */

    /* INHERITED: A short help description to appear alongside the field in a UI 
    public String help = "";
     */

    /* INHERITED: The label that should be displayed for the field if the name is insufficient 
    public String label = "";
     */

    /* INHERITED: Is this field required, or is the default value generally sufficient? 
    public boolean required = false;
     */

    /* INHERITED: How important is this field?  The web UI uses the level to do a slow reveal of the parameters 
    public ApiAPILevel level = null;
     */

    /* INHERITED: Is this field an input, output or inout? 
    public ApiAPIDirection direction = null;
     */

    /* INHERITED: Is the field inherited from the parent schema? 
    public boolean is_inherited = false;
     */

    /* INHERITED: If this field is inherited from a class higher in the hierarchy which one? 
    public String inherited_from = "";
     */

    /* INHERITED: Is the field gridable (i.e., it can be used in grid call) 
    public boolean is_gridable = false;
     */

    /* INHERITED: For enum-type fields the allowed values are specified using the values annotation;  this is used in UIs to tell the user the allowed values, and for validation 
    public String[] values = null;
     */

    /* INHERITED: Should this field be rendered in the JSON representation? 
    public boolean json = false;
     */

    /* INHERITED: For Vec-type fields this is the set of other Vec-type fields which must contain mutually exclusive values; for example, for a SupervisedModel the response_column must be mutually exclusive with the weights_column 
    public String[] is_member_of_frames = null;
     */

    /* INHERITED: For Vec-type fields this is the set of Frame-type fields which must contain the named column; for example, for a SupervisedModel the response_column must be in both the training_frame and (if it's set) the validation_frame 
    public String[] is_mutually_exclusive_with = null;
     */

    public FieldMetadataV3() {
        name = "";
        type = "";
        is_schema = false;
        schema_name = "";
        value = null;
        help = "";
        label = "";
        required = false;
        level = null;
        direction = null;
        is_inherited = false;
        inherited_from = "";
        is_gridable = false;
        values = null;
        json = false;
        is_member_of_frames = null;
        is_mutually_exclusive_with = null;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
