package water.bindings.pojos;

import com.google.gson.Gson;

public class GLMParametersV3 extends ModelParametersSchema {
    /** Family. Use binomial for classification with logistic regression, others are for regression problems. */
    public GlmGLMModelGLMParametersFamily family;

    /** Tweedie variance power */
    public double tweedie_variance_power;

    /** Tweedie link power */
    public double tweedie_link_power;

    /** AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on problems with small number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for datasets with many columns. Coordinate descent is experimental (beta). */
    public GlmGLMModelGLMParametersSolver solver;

    /** distribution of regularization between L1 and L2. */
    public double[] alpha;

    /** regularization strength */
    public double[] lambda;

    /** use lambda search starting at lambda max, given lambda is then interpreted as lambda min */
    public boolean lambda_search;

    /** number of lambdas to be used in a search */
    public int nlambdas;

    /** Standardize numeric columns to have zero mean and unit variance */
    public boolean standardize;

    /** Handling of missing values. Either Skip or MeanImputation. */
    public DeeplearningDeepLearningModelDeepLearningParametersMissingValuesHandling missing_values_handling;

    /** Restrict coefficients (not intercept) to be non-negative */
    public boolean non_negative;

    /** Maximum number of iterations */
    public int max_iterations;

    /** converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to IRLSM solver  */
    public double beta_epsilon;

    /** converge if  objective value changes less than this */
    public double objective_epsilon;

    /** converge if  objective changes less (using L-infinity norm) than this, ONLY applies to L-BFGS solver */
    public double gradient_epsilon;

    /** likelihood divider in objective value computation, default is 1/nobs */
    public double obj_reg;

    /**  */
    public GlmGLMModelGLMParametersLink link;

    /** include constant term in the model */
    public boolean intercept;

    /** prior probability for y==1. To be used only for logistic regression iff the data has been sampled and the mean of response does not reflect reality. */
    public double prior;

    /** min lambda used in lambda search, specified as a ratio of lambda_max */
    public double lambda_min_ratio;

    /** beta constraints */
    public FrameKeyV3 beta_constraints;

    /** Maximum number of active predictors during computation. Use as a stopping criterium to prevent expensive model building with many predictors. */
    public int max_active_predictors;

    /** A list of predictor column indices to interact. All pairwise combinations will be computed for the list. */
    public String[] interactions;

    /** Balance training data class counts via over/under-sampling (for imbalanced data). */
    public boolean balance_classes;

    /** Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes. */
    public float[] class_sampling_factors;

    /** Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes. */
    public float max_after_balance_size;

    /** Maximum size (# classes) for confusion matrices to be printed in the Logs */
    public int max_confusion_matrix_size;

    /** Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable) */
    public int max_hit_ratio_k;

    /** request p-values computation, p-values work only with IRLSM solver and no regularization */
    public boolean compute_p_values;

    /** in case of linearly dependent columns remove some of the dependent columns */
    public boolean remove_collinear_columns;

    /* INHERITED: Destination id for this model; auto-generated if not specified 
    public ModelKeyV3 model_id = null;
     */

    /* INHERITED: Training frame 
    public FrameKeyV3 training_frame = null;
     */

    /* INHERITED: Validation frame 
    public FrameKeyV3 validation_frame = null;
     */

    /* INHERITED: Number of folds for N-fold cross-validation 
    public int nfolds = 0;
     */

    /* INHERITED: Keep cross-validation model predictions 
    public boolean keep_cross_validation_predictions = false;
     */

    /* INHERITED: Keep cross-validation fold assignment 
    public boolean keep_cross_validation_fold_assignment = false;
     */

    /* INHERITED: Allow parallel training of cross-validation models 
    public boolean parallelize_cross_validation = true;
     */

    /* INHERITED: Response column 
    public ColSpecifierV3 response_column = null;
     */

    /* INHERITED: Column with observation weights 
    public ColSpecifierV3 weights_column = null;
     */

    /* INHERITED: Offset column 
    public ColSpecifierV3 offset_column = null;
     */

    /* INHERITED: Column with cross-validation fold index assignment per observation 
    public ColSpecifierV3 fold_column = null;
     */

    /* INHERITED: Cross-validation fold assignment scheme, if fold_column is not specified 
    public ModelParametersFoldAssignmentScheme fold_assignment = ModelParametersFoldAssignmentScheme.AUTO;
     */

    /* INHERITED: Ignored columns 
    public String[] ignored_columns = null;
     */

    /* INHERITED: Ignore constant columns 
    public boolean ignore_const_cols = true;
     */

    /* INHERITED: Whether to score during each iteration of model training 
    public boolean score_each_iteration = false;
     */

    /* INHERITED: Model checkpoint to resume training with 
    public ModelKeyV3 checkpoint = null;
     */

    /* INHERITED: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) 
    public int stopping_rounds = 0;
     */

    /* INHERITED: Maximum allowed runtime in seconds for model training. Use 0 to disable. 
    public double max_runtime_secs = 0.0;
     */

    /* INHERITED: Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) 
    public ScoreKeeperStoppingMetric stopping_metric = ScoreKeeperStoppingMetric.AUTO;
     */

    /* INHERITED: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) 
    public double stopping_tolerance = 0.001;
     */

    public GLMParametersV3() {
        family = GlmGLMModelGLMParametersFamily.gaussian;
        tweedie_variance_power = 0.0;
        tweedie_link_power = 1.0;
        solver = GlmGLMModelGLMParametersSolver.IRLSM;
        alpha = null;
        lambda = null;
        lambda_search = false;
        nlambdas = -1;
        standardize = true;
        missing_values_handling = DeeplearningDeepLearningModelDeepLearningParametersMissingValuesHandling.MeanImputation;
        non_negative = false;
        max_iterations = -1;
        beta_epsilon = 0.0001;
        objective_epsilon = -1.0;
        gradient_epsilon = 0.0001;
        obj_reg = -1.0;
        link = GlmGLMModelGLMParametersLink.family_default;
        intercept = true;
        prior = -1.0;
        lambda_min_ratio = -1.0;
        beta_constraints = null;
        max_active_predictors = -1;
        interactions = null;
        balance_classes = false;
        class_sampling_factors = null;
        max_after_balance_size = 5.0f;
        max_confusion_matrix_size = 20;
        max_hit_ratio_k = 0;
        compute_p_values = false;
        remove_collinear_columns = false;
        model_id = null;
        training_frame = null;
        validation_frame = null;
        nfolds = 0;
        keep_cross_validation_predictions = false;
        keep_cross_validation_fold_assignment = false;
        parallelize_cross_validation = true;
        response_column = null;
        weights_column = null;
        offset_column = null;
        fold_column = null;
        fold_assignment = ModelParametersFoldAssignmentScheme.AUTO;
        ignored_columns = null;
        ignore_const_cols = true;
        score_each_iteration = false;
        checkpoint = null;
        stopping_rounds = 0;
        max_runtime_secs = 0.0;
        stopping_metric = ScoreKeeperStoppingMetric.AUTO;
        stopping_tolerance = 0.001;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
