package water.bindings.pojos;

import com.google.gson.Gson;

public class GridSchemaV99 extends Schema {
    /** Grid id */
    public GridKeyV3 grid_id;

    /** Model performance metric to sort by. Examples: logloss, residual_deviance, mse, auc, r2, f1, recall, precision, accuracy, mcc, err, err_count, lift_top_group, max_per_class_error */
    public String sort_by;

    /** Specify whether sort order should be decreasing. */
    public boolean decreasing;

    /** Model IDs built by a grid search */
    public ModelKeyV3[] model_ids;

    /** Used hyper parameters. */
    public String[] hyper_names;

    /** List of failed parameters */
    public ModelParametersSchema[] failed_params;

    /** List of detailed failure messages */
    public String[] failure_details;

    /** List of detailed failure stack traces */
    public String[] failure_stack_traces;

    /** List of raw parameters causing model building failure */
    public String[][] failed_raw_params;

    /** Training model metrics for the returned models; only returned if sort_by is set */
    public ModelMetricsBase[] training_metrics;

    /** Validation model metrics for the returned models; only returned if sort_by is set */
    public ModelMetricsBase[] validation_metrics;

    /** Cross validation model metrics for the returned models; only returned if sort_by is set */
    public ModelMetricsBase[] cross_validation_metrics;

    /** Cross validation model metrics summary for the returned models; only returned if sort_by is set */
    public TwoDimTableV3[] cross_validation_metrics_summary;

    /** Summary */
    public TwoDimTableV3 summary_table;

    /** Scoring history */
    public TwoDimTableV3 scoring_history;

    public GridSchemaV99() {
        grid_id = null;
        sort_by = "";
        decreasing = false;
        model_ids = null;
        hyper_names = null;
        failed_params = null;
        failure_details = null;
        failure_stack_traces = null;
        failed_raw_params = null;
        training_metrics = null;
        validation_metrics = null;
        cross_validation_metrics = null;
        cross_validation_metrics_summary = null;
        summary_table = null;
        scoring_history = null;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
