package water.bindings.pojos;

import com.google.gson.Gson;

public class ModelBuilderSchema extends RequestSchema {
    /** Model builder parameters. */
    public ModelParameterSchemaV3[] parameters;
    /** The algo name for this ModelBuilder. */
    public String algo;

    /** The pretty algo name for this ModelBuilder (e.g., Generalized Linear Model, rather than GLM). */
    public String algo_full_name;

    /** Model categories this ModelBuilder can build. */
    public ModelCategory[] can_build;

    /** Should the builder always be visible, be marked as beta, or only visible if the user starts up with the experimental flag? */
    public ModelBuilderBuilderVisibility visibility;

    /** Job Key */
    public JobV3 job;

    /** Parameter validation messages */
    public ValidationMessageBase[] messages;

    /** Count of parameter validation errors */
    public int error_count;

    /** HTTP status to return for this build. */
    public int __http_status;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public ModelBuilderSchema() {
        algo = "";
        algo_full_name = "";
        can_build = null;
        visibility = null;
        job = null;
        messages = null;
        error_count = 0;
        __http_status = 0;
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
