package water.bindings.pojos;

import com.google.gson.Gson;

public class ModelMetricsListSchemaV3 extends RequestSchema {
    /** Key of Model of interest (optional) */
    public ModelKeyV3 model;

    /** Key of Frame of interest (optional) */
    public FrameKeyV3 frame;

    /** Key of predictions frame, if predictions are requested (optional) */
    public FrameKeyV3 predictions_frame;

    /** Compute reconstruction error (optional, only for Deep Learning AutoEncoder models) */
    public boolean reconstruction_error;

    /** Compute reconstruction error per feature (optional, only for Deep Learning AutoEncoder models) */
    public boolean reconstruction_error_per_feature;

    /** Extract Deep Features for given hidden layer (optional, only for Deep Learning models) */
    public int deep_features_hidden_layer;

    /** Reconstruct original training frame (optional, only for GLRM models) */
    public boolean reconstruct_train;

    /** Project GLRM archetypes back into original feature space (optional, only for GLRM models) */
    public boolean project_archetypes;

    /** Reverse transformation applied during training to model output (optional, only for GLRM models) */
    public boolean reverse_transform;

    /** Return the leaf node assignment (optional, only for DRF/GBM models) */
    public boolean leaf_node_assignment;

    /** Retrieve all members for a given exemplar (optional, only for Aggregator models) */
    public int exemplar_index;

    /** ModelMetrics */
    public ModelMetricsBase[] model_metrics;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public ModelMetricsListSchemaV3() {
        model = null;
        frame = null;
        predictions_frame = null;
        reconstruction_error = false;
        reconstruction_error_per_feature = false;
        deep_features_hidden_layer = -1;
        reconstruct_train = false;
        project_archetypes = false;
        reverse_transform = false;
        leaf_node_assignment = false;
        exemplar_index = -1;
        model_metrics = new ModelMetricsBase[]{};
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
