package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Metadata {
    /** Return the REST API endpoint metadata, including documentation, for the endpoint specified by number. */
    @GET("/3/Metadata/endpoints/(?<num>[0-9]+)")
    Call<MetadataV3> fetchRoute(@Path("num") int num);

    /** Return the REST API endpoint metadata, including documentation, for the endpoint specified by path. */
    @GET("/3/Metadata/endpoints/{path}")
    Call<MetadataV3> fetchRoute(@Path("path") String path);

    /** Return a list of all the REST API endpoints. */
    @GET("/3/Metadata/endpoints")
    Call<MetadataV3> listRoutes();

    /** Return the REST API schema metadata for specified schema class. */
    @GET("/3/Metadata/schemaclasses/{classname}")
    Call<MetadataV3> fetchSchemaMetadataByClass(@Path("classname") String classname);

    /** Return the REST API schema metadata for specified schema. */
    @GET("/3/Metadata/schemas/{schemaname}")
    Call<MetadataV3> fetchSchemaMetadata(@Path("schemaname") String schemaname);

    /** Return list of all REST API schemas. */
    @GET("/3/Metadata/schemas")
    Call<MetadataV3> listSchemas();
}
