package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface ModelBuilders {
    /** Return a new unique model_id for the specified algorithm. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/{algo}/model_id")
    Call<ModelIdV3> calcModelId(@Path("algo") String algo,
                                @Field("_exclude_fields") String _exclude_fields);

    /** Return the Model Builder metadata for the specified algorithm. */
    @GET("/3/ModelBuilders/{algo}")
    Call<ModelBuildersV3> fetch(@Path("algo") String algo);

    /** Return the Model Builder metadata for all available algorithms. */
    @GET("/3/ModelBuilders")
    Call<ModelBuildersV3> list();

    /** Train a DeepLearning model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/deeplearning")
    Call<DeepLearningV3> train_deeplearning(@Field("balance_classes") boolean balance_classes,
                                            @Field("class_sampling_factors") float[] class_sampling_factors,
                                            @Field("max_after_balance_size") float max_after_balance_size,
                                            @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                                            @Field("max_hit_ratio_k") int max_hit_ratio_k,
                                            @Field("overwrite_with_best_model") boolean overwrite_with_best_model,
                                            @Field("autoencoder") boolean autoencoder,
                                            @Field("use_all_factor_levels") boolean use_all_factor_levels,
                                            @Field("standardize") boolean standardize,
                                            @Field("activation") DeeplearningDeepLearningModelDeepLearningParametersActivation activation,
                                            @Field("hidden") int[] hidden,
                                            @Field("epochs") double epochs,
                                            @Field("train_samples_per_iteration") long train_samples_per_iteration,
                                            @Field("target_ratio_comm_to_comp") double target_ratio_comm_to_comp,
                                            @Field("seed") long seed,
                                            @Field("adaptive_rate") boolean adaptive_rate,
                                            @Field("rho") double rho,
                                            @Field("epsilon") double epsilon,
                                            @Field("rate") double rate,
                                            @Field("rate_annealing") double rate_annealing,
                                            @Field("rate_decay") double rate_decay,
                                            @Field("momentum_start") double momentum_start,
                                            @Field("momentum_ramp") double momentum_ramp,
                                            @Field("momentum_stable") double momentum_stable,
                                            @Field("nesterov_accelerated_gradient") boolean nesterov_accelerated_gradient,
                                            @Field("input_dropout_ratio") double input_dropout_ratio,
                                            @Field("hidden_dropout_ratios") double[] hidden_dropout_ratios,
                                            @Field("l1") double l1,
                                            @Field("l2") double l2,
                                            @Field("max_w2") float max_w2,
                                            @Field("initial_weight_distribution") DeeplearningDeepLearningModelDeepLearningParametersInitialWeightDistribution initial_weight_distribution,
                                            @Field("initial_weight_scale") double initial_weight_scale,
                                            @Field("initial_weights") String[] initial_weights,
                                            @Field("initial_biases") String[] initial_biases,
                                            @Field("loss") DeeplearningDeepLearningModelDeepLearningParametersLoss loss,
                                            @Field("distribution") DistributionFamily distribution,
                                            @Field("tweedie_power") double tweedie_power,
                                            @Field("quantile_alpha") double quantile_alpha,
                                            @Field("score_interval") double score_interval,
                                            @Field("score_training_samples") long score_training_samples,
                                            @Field("score_validation_samples") long score_validation_samples,
                                            @Field("score_duty_cycle") double score_duty_cycle,
                                            @Field("classification_stop") double classification_stop,
                                            @Field("regression_stop") double regression_stop,
                                            @Field("quiet_mode") boolean quiet_mode,
                                            @Field("score_validation_sampling") DeeplearningDeepLearningModelDeepLearningParametersClassSamplingMethod score_validation_sampling,
                                            @Field("diagnostics") boolean diagnostics,
                                            @Field("variable_importances") boolean variable_importances,
                                            @Field("fast_mode") boolean fast_mode,
                                            @Field("force_load_balance") boolean force_load_balance,
                                            @Field("replicate_training_data") boolean replicate_training_data,
                                            @Field("single_node_mode") boolean single_node_mode,
                                            @Field("shuffle_training_data") boolean shuffle_training_data,
                                            @Field("missing_values_handling") DeeplearningDeepLearningModelDeepLearningParametersMissingValuesHandling missing_values_handling,
                                            @Field("sparse") boolean sparse,
                                            @Field("col_major") boolean col_major,
                                            @Field("average_activation") double average_activation,
                                            @Field("sparsity_beta") double sparsity_beta,
                                            @Field("max_categorical_features") int max_categorical_features,
                                            @Field("reproducible") boolean reproducible,
                                            @Field("export_weights_and_biases") boolean export_weights_and_biases,
                                            @Field("mini_batch_size") int mini_batch_size,
                                            @Field("elastic_averaging") boolean elastic_averaging,
                                            @Field("elastic_averaging_moving_rate") double elastic_averaging_moving_rate,
                                            @Field("elastic_averaging_regularization") double elastic_averaging_regularization,
                                            @Field("pretrained_autoencoder") String pretrained_autoencoder,
                                            @Field("model_id") String model_id,
                                            @Field("training_frame") String training_frame,
                                            @Field("validation_frame") String validation_frame,
                                            @Field("nfolds") int nfolds,
                                            @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                            @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                            @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                            @Field("response_column") String response_column,
                                            @Field("weights_column") String weights_column,
                                            @Field("offset_column") String offset_column,
                                            @Field("fold_column") String fold_column,
                                            @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                            @Field("ignored_columns") String[] ignored_columns,
                                            @Field("ignore_const_cols") boolean ignore_const_cols,
                                            @Field("score_each_iteration") boolean score_each_iteration,
                                            @Field("checkpoint") String checkpoint,
                                            @Field("stopping_rounds") int stopping_rounds,
                                            @Field("max_runtime_secs") double max_runtime_secs,
                                            @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                            @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of DeepLearning model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/deeplearning/parameters")
    Call<DeepLearningV3> validate_parameters_deeplearning(@Field("balance_classes") boolean balance_classes,
                                                          @Field("class_sampling_factors") float[] class_sampling_factors,
                                                          @Field("max_after_balance_size") float max_after_balance_size,
                                                          @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                                                          @Field("max_hit_ratio_k") int max_hit_ratio_k,
                                                          @Field("overwrite_with_best_model") boolean overwrite_with_best_model,
                                                          @Field("autoencoder") boolean autoencoder,
                                                          @Field("use_all_factor_levels") boolean use_all_factor_levels,
                                                          @Field("standardize") boolean standardize,
                                                          @Field("activation") DeeplearningDeepLearningModelDeepLearningParametersActivation activation,
                                                          @Field("hidden") int[] hidden,
                                                          @Field("epochs") double epochs,
                                                          @Field("train_samples_per_iteration") long train_samples_per_iteration,
                                                          @Field("target_ratio_comm_to_comp") double target_ratio_comm_to_comp,
                                                          @Field("seed") long seed,
                                                          @Field("adaptive_rate") boolean adaptive_rate,
                                                          @Field("rho") double rho,
                                                          @Field("epsilon") double epsilon,
                                                          @Field("rate") double rate,
                                                          @Field("rate_annealing") double rate_annealing,
                                                          @Field("rate_decay") double rate_decay,
                                                          @Field("momentum_start") double momentum_start,
                                                          @Field("momentum_ramp") double momentum_ramp,
                                                          @Field("momentum_stable") double momentum_stable,
                                                          @Field("nesterov_accelerated_gradient") boolean nesterov_accelerated_gradient,
                                                          @Field("input_dropout_ratio") double input_dropout_ratio,
                                                          @Field("hidden_dropout_ratios") double[] hidden_dropout_ratios,
                                                          @Field("l1") double l1,
                                                          @Field("l2") double l2,
                                                          @Field("max_w2") float max_w2,
                                                          @Field("initial_weight_distribution") DeeplearningDeepLearningModelDeepLearningParametersInitialWeightDistribution initial_weight_distribution,
                                                          @Field("initial_weight_scale") double initial_weight_scale,
                                                          @Field("initial_weights") String[] initial_weights,
                                                          @Field("initial_biases") String[] initial_biases,
                                                          @Field("loss") DeeplearningDeepLearningModelDeepLearningParametersLoss loss,
                                                          @Field("distribution") DistributionFamily distribution,
                                                          @Field("tweedie_power") double tweedie_power,
                                                          @Field("quantile_alpha") double quantile_alpha,
                                                          @Field("score_interval") double score_interval,
                                                          @Field("score_training_samples") long score_training_samples,
                                                          @Field("score_validation_samples") long score_validation_samples,
                                                          @Field("score_duty_cycle") double score_duty_cycle,
                                                          @Field("classification_stop") double classification_stop,
                                                          @Field("regression_stop") double regression_stop,
                                                          @Field("quiet_mode") boolean quiet_mode,
                                                          @Field("score_validation_sampling") DeeplearningDeepLearningModelDeepLearningParametersClassSamplingMethod score_validation_sampling,
                                                          @Field("diagnostics") boolean diagnostics,
                                                          @Field("variable_importances") boolean variable_importances,
                                                          @Field("fast_mode") boolean fast_mode,
                                                          @Field("force_load_balance") boolean force_load_balance,
                                                          @Field("replicate_training_data") boolean replicate_training_data,
                                                          @Field("single_node_mode") boolean single_node_mode,
                                                          @Field("shuffle_training_data") boolean shuffle_training_data,
                                                          @Field("missing_values_handling") DeeplearningDeepLearningModelDeepLearningParametersMissingValuesHandling missing_values_handling,
                                                          @Field("sparse") boolean sparse,
                                                          @Field("col_major") boolean col_major,
                                                          @Field("average_activation") double average_activation,
                                                          @Field("sparsity_beta") double sparsity_beta,
                                                          @Field("max_categorical_features") int max_categorical_features,
                                                          @Field("reproducible") boolean reproducible,
                                                          @Field("export_weights_and_biases") boolean export_weights_and_biases,
                                                          @Field("mini_batch_size") int mini_batch_size,
                                                          @Field("elastic_averaging") boolean elastic_averaging,
                                                          @Field("elastic_averaging_moving_rate") double elastic_averaging_moving_rate,
                                                          @Field("elastic_averaging_regularization") double elastic_averaging_regularization,
                                                          @Field("pretrained_autoencoder") String pretrained_autoencoder,
                                                          @Field("model_id") String model_id,
                                                          @Field("training_frame") String training_frame,
                                                          @Field("validation_frame") String validation_frame,
                                                          @Field("nfolds") int nfolds,
                                                          @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                                          @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                                          @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                                          @Field("response_column") String response_column,
                                                          @Field("weights_column") String weights_column,
                                                          @Field("offset_column") String offset_column,
                                                          @Field("fold_column") String fold_column,
                                                          @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                                          @Field("ignored_columns") String[] ignored_columns,
                                                          @Field("ignore_const_cols") boolean ignore_const_cols,
                                                          @Field("score_each_iteration") boolean score_each_iteration,
                                                          @Field("checkpoint") String checkpoint,
                                                          @Field("stopping_rounds") int stopping_rounds,
                                                          @Field("max_runtime_secs") double max_runtime_secs,
                                                          @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                                          @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a GLM model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/glm")
    Call<GLMV3> train_glm(@Field("family") GlmGLMModelGLMParametersFamily family,
                          @Field("tweedie_variance_power") double tweedie_variance_power,
                          @Field("tweedie_link_power") double tweedie_link_power,
                          @Field("solver") GlmGLMModelGLMParametersSolver solver,
                          @Field("alpha") double[] alpha,
                          @Field("lambda") double[] lambda,
                          @Field("lambda_search") boolean lambda_search,
                          @Field("nlambdas") int nlambdas,
                          @Field("standardize") boolean standardize,
                          @Field("missing_values_handling") DeeplearningDeepLearningModelDeepLearningParametersMissingValuesHandling missing_values_handling,
                          @Field("non_negative") boolean non_negative,
                          @Field("max_iterations") int max_iterations,
                          @Field("beta_epsilon") double beta_epsilon,
                          @Field("objective_epsilon") double objective_epsilon,
                          @Field("gradient_epsilon") double gradient_epsilon,
                          @Field("obj_reg") double obj_reg,
                          @Field("link") GlmGLMModelGLMParametersLink link,
                          @Field("intercept") boolean intercept,
                          @Field("prior") double prior,
                          @Field("lambda_min_ratio") double lambda_min_ratio,
                          @Field("beta_constraints") String beta_constraints,
                          @Field("max_active_predictors") int max_active_predictors,
                          @Field("interactions") String[] interactions,
                          @Field("balance_classes") boolean balance_classes,
                          @Field("class_sampling_factors") float[] class_sampling_factors,
                          @Field("max_after_balance_size") float max_after_balance_size,
                          @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                          @Field("max_hit_ratio_k") int max_hit_ratio_k,
                          @Field("compute_p_values") boolean compute_p_values,
                          @Field("remove_collinear_columns") boolean remove_collinear_columns,
                          @Field("model_id") String model_id,
                          @Field("training_frame") String training_frame,
                          @Field("validation_frame") String validation_frame,
                          @Field("nfolds") int nfolds,
                          @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                          @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                          @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                          @Field("response_column") String response_column,
                          @Field("weights_column") String weights_column,
                          @Field("offset_column") String offset_column,
                          @Field("fold_column") String fold_column,
                          @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                          @Field("ignored_columns") String[] ignored_columns,
                          @Field("ignore_const_cols") boolean ignore_const_cols,
                          @Field("score_each_iteration") boolean score_each_iteration,
                          @Field("checkpoint") String checkpoint,
                          @Field("stopping_rounds") int stopping_rounds,
                          @Field("max_runtime_secs") double max_runtime_secs,
                          @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                          @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of GLM model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/glm/parameters")
    Call<GLMV3> validate_parameters_glm(@Field("family") GlmGLMModelGLMParametersFamily family,
                                        @Field("tweedie_variance_power") double tweedie_variance_power,
                                        @Field("tweedie_link_power") double tweedie_link_power,
                                        @Field("solver") GlmGLMModelGLMParametersSolver solver,
                                        @Field("alpha") double[] alpha,
                                        @Field("lambda") double[] lambda,
                                        @Field("lambda_search") boolean lambda_search,
                                        @Field("nlambdas") int nlambdas,
                                        @Field("standardize") boolean standardize,
                                        @Field("missing_values_handling") DeeplearningDeepLearningModelDeepLearningParametersMissingValuesHandling missing_values_handling,
                                        @Field("non_negative") boolean non_negative,
                                        @Field("max_iterations") int max_iterations,
                                        @Field("beta_epsilon") double beta_epsilon,
                                        @Field("objective_epsilon") double objective_epsilon,
                                        @Field("gradient_epsilon") double gradient_epsilon,
                                        @Field("obj_reg") double obj_reg,
                                        @Field("link") GlmGLMModelGLMParametersLink link,
                                        @Field("intercept") boolean intercept,
                                        @Field("prior") double prior,
                                        @Field("lambda_min_ratio") double lambda_min_ratio,
                                        @Field("beta_constraints") String beta_constraints,
                                        @Field("max_active_predictors") int max_active_predictors,
                                        @Field("interactions") String[] interactions,
                                        @Field("balance_classes") boolean balance_classes,
                                        @Field("class_sampling_factors") float[] class_sampling_factors,
                                        @Field("max_after_balance_size") float max_after_balance_size,
                                        @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                                        @Field("max_hit_ratio_k") int max_hit_ratio_k,
                                        @Field("compute_p_values") boolean compute_p_values,
                                        @Field("remove_collinear_columns") boolean remove_collinear_columns,
                                        @Field("model_id") String model_id,
                                        @Field("training_frame") String training_frame,
                                        @Field("validation_frame") String validation_frame,
                                        @Field("nfolds") int nfolds,
                                        @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                        @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                        @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                        @Field("response_column") String response_column,
                                        @Field("weights_column") String weights_column,
                                        @Field("offset_column") String offset_column,
                                        @Field("fold_column") String fold_column,
                                        @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                        @Field("ignored_columns") String[] ignored_columns,
                                        @Field("ignore_const_cols") boolean ignore_const_cols,
                                        @Field("score_each_iteration") boolean score_each_iteration,
                                        @Field("checkpoint") String checkpoint,
                                        @Field("stopping_rounds") int stopping_rounds,
                                        @Field("max_runtime_secs") double max_runtime_secs,
                                        @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                        @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a GLRM model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/glrm")
    Call<GLRMV3> train_glrm(@Field("transform") DataInfoTransformType transform,
                            @Field("k") int k,
                            @Field("loss") GlrmGLRMModelGLRMParametersLoss loss,
                            @Field("multi_loss") GlrmGLRMModelGLRMParametersLoss multi_loss,
                            @Field("loss_by_col") GlrmGLRMModelGLRMParametersLoss[] loss_by_col,
                            @Field("loss_by_col_idx") int[] loss_by_col_idx,
                            @Field("period") int period,
                            @Field("regularization_x") GlrmGLRMModelGLRMParametersRegularizer regularization_x,
                            @Field("regularization_y") GlrmGLRMModelGLRMParametersRegularizer regularization_y,
                            @Field("gamma_x") double gamma_x,
                            @Field("gamma_y") double gamma_y,
                            @Field("max_iterations") int max_iterations,
                            @Field("max_updates") int max_updates,
                            @Field("init_step_size") double init_step_size,
                            @Field("min_step_size") double min_step_size,
                            @Field("seed") long seed,
                            @Field("init") GlrmGLRMInitialization init,
                            @Field("svd_method") SvdSVDModelSVDParametersMethod svd_method,
                            @Field("user_y") String user_y,
                            @Field("user_x") String user_x,
                            @Field("loading_name") String loading_name,
                            @Field("expand_user_y") boolean expand_user_y,
                            @Field("impute_original") boolean impute_original,
                            @Field("recover_svd") boolean recover_svd,
                            @Field("model_id") String model_id,
                            @Field("training_frame") String training_frame,
                            @Field("validation_frame") String validation_frame,
                            @Field("nfolds") int nfolds,
                            @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                            @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                            @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                            @Field("response_column") String response_column,
                            @Field("weights_column") String weights_column,
                            @Field("offset_column") String offset_column,
                            @Field("fold_column") String fold_column,
                            @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                            @Field("ignored_columns") String[] ignored_columns,
                            @Field("ignore_const_cols") boolean ignore_const_cols,
                            @Field("score_each_iteration") boolean score_each_iteration,
                            @Field("checkpoint") String checkpoint,
                            @Field("stopping_rounds") int stopping_rounds,
                            @Field("max_runtime_secs") double max_runtime_secs,
                            @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                            @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of GLRM model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/glrm/parameters")
    Call<GLRMV3> validate_parameters_glrm(@Field("transform") DataInfoTransformType transform,
                                          @Field("k") int k,
                                          @Field("loss") GlrmGLRMModelGLRMParametersLoss loss,
                                          @Field("multi_loss") GlrmGLRMModelGLRMParametersLoss multi_loss,
                                          @Field("loss_by_col") GlrmGLRMModelGLRMParametersLoss[] loss_by_col,
                                          @Field("loss_by_col_idx") int[] loss_by_col_idx,
                                          @Field("period") int period,
                                          @Field("regularization_x") GlrmGLRMModelGLRMParametersRegularizer regularization_x,
                                          @Field("regularization_y") GlrmGLRMModelGLRMParametersRegularizer regularization_y,
                                          @Field("gamma_x") double gamma_x,
                                          @Field("gamma_y") double gamma_y,
                                          @Field("max_iterations") int max_iterations,
                                          @Field("max_updates") int max_updates,
                                          @Field("init_step_size") double init_step_size,
                                          @Field("min_step_size") double min_step_size,
                                          @Field("seed") long seed,
                                          @Field("init") GlrmGLRMInitialization init,
                                          @Field("svd_method") SvdSVDModelSVDParametersMethod svd_method,
                                          @Field("user_y") String user_y,
                                          @Field("user_x") String user_x,
                                          @Field("loading_name") String loading_name,
                                          @Field("expand_user_y") boolean expand_user_y,
                                          @Field("impute_original") boolean impute_original,
                                          @Field("recover_svd") boolean recover_svd,
                                          @Field("model_id") String model_id,
                                          @Field("training_frame") String training_frame,
                                          @Field("validation_frame") String validation_frame,
                                          @Field("nfolds") int nfolds,
                                          @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                          @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                          @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                          @Field("response_column") String response_column,
                                          @Field("weights_column") String weights_column,
                                          @Field("offset_column") String offset_column,
                                          @Field("fold_column") String fold_column,
                                          @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                          @Field("ignored_columns") String[] ignored_columns,
                                          @Field("ignore_const_cols") boolean ignore_const_cols,
                                          @Field("score_each_iteration") boolean score_each_iteration,
                                          @Field("checkpoint") String checkpoint,
                                          @Field("stopping_rounds") int stopping_rounds,
                                          @Field("max_runtime_secs") double max_runtime_secs,
                                          @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                          @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a KMeans model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/kmeans")
    Call<KMeansV3> train_kmeans(@Field("user_points") String user_points,
                                @Field("max_iterations") int max_iterations,
                                @Field("standardize") boolean standardize,
                                @Field("seed") long seed,
                                @Field("init") KmeansKMeansInitialization init,
                                @Field("k") int k,
                                @Field("model_id") String model_id,
                                @Field("training_frame") String training_frame,
                                @Field("validation_frame") String validation_frame,
                                @Field("nfolds") int nfolds,
                                @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                @Field("response_column") String response_column,
                                @Field("weights_column") String weights_column,
                                @Field("offset_column") String offset_column,
                                @Field("fold_column") String fold_column,
                                @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                @Field("ignored_columns") String[] ignored_columns,
                                @Field("ignore_const_cols") boolean ignore_const_cols,
                                @Field("score_each_iteration") boolean score_each_iteration,
                                @Field("checkpoint") String checkpoint,
                                @Field("stopping_rounds") int stopping_rounds,
                                @Field("max_runtime_secs") double max_runtime_secs,
                                @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of KMeans model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/kmeans/parameters")
    Call<KMeansV3> validate_parameters_kmeans(@Field("user_points") String user_points,
                                              @Field("max_iterations") int max_iterations,
                                              @Field("standardize") boolean standardize,
                                              @Field("seed") long seed,
                                              @Field("init") KmeansKMeansInitialization init,
                                              @Field("k") int k,
                                              @Field("model_id") String model_id,
                                              @Field("training_frame") String training_frame,
                                              @Field("validation_frame") String validation_frame,
                                              @Field("nfolds") int nfolds,
                                              @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                              @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                              @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                              @Field("response_column") String response_column,
                                              @Field("weights_column") String weights_column,
                                              @Field("offset_column") String offset_column,
                                              @Field("fold_column") String fold_column,
                                              @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                              @Field("ignored_columns") String[] ignored_columns,
                                              @Field("ignore_const_cols") boolean ignore_const_cols,
                                              @Field("score_each_iteration") boolean score_each_iteration,
                                              @Field("checkpoint") String checkpoint,
                                              @Field("stopping_rounds") int stopping_rounds,
                                              @Field("max_runtime_secs") double max_runtime_secs,
                                              @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                              @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a NaiveBayes model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/naivebayes")
    Call<NaiveBayesV3> train_naivebayes(@Field("balance_classes") boolean balance_classes,
                                        @Field("class_sampling_factors") float[] class_sampling_factors,
                                        @Field("max_after_balance_size") float max_after_balance_size,
                                        @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                                        @Field("max_hit_ratio_k") int max_hit_ratio_k,
                                        @Field("laplace") double laplace,
                                        @Field("min_sdev") double min_sdev,
                                        @Field("eps_sdev") double eps_sdev,
                                        @Field("min_prob") double min_prob,
                                        @Field("eps_prob") double eps_prob,
                                        @Field("compute_metrics") boolean compute_metrics,
                                        @Field("seed") long seed,
                                        @Field("model_id") String model_id,
                                        @Field("training_frame") String training_frame,
                                        @Field("validation_frame") String validation_frame,
                                        @Field("nfolds") int nfolds,
                                        @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                        @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                        @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                        @Field("response_column") String response_column,
                                        @Field("weights_column") String weights_column,
                                        @Field("offset_column") String offset_column,
                                        @Field("fold_column") String fold_column,
                                        @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                        @Field("ignored_columns") String[] ignored_columns,
                                        @Field("ignore_const_cols") boolean ignore_const_cols,
                                        @Field("score_each_iteration") boolean score_each_iteration,
                                        @Field("checkpoint") String checkpoint,
                                        @Field("stopping_rounds") int stopping_rounds,
                                        @Field("max_runtime_secs") double max_runtime_secs,
                                        @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                        @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of NaiveBayes model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/naivebayes/parameters")
    Call<NaiveBayesV3> validate_parameters_naivebayes(@Field("balance_classes") boolean balance_classes,
                                                      @Field("class_sampling_factors") float[] class_sampling_factors,
                                                      @Field("max_after_balance_size") float max_after_balance_size,
                                                      @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                                                      @Field("max_hit_ratio_k") int max_hit_ratio_k,
                                                      @Field("laplace") double laplace,
                                                      @Field("min_sdev") double min_sdev,
                                                      @Field("eps_sdev") double eps_sdev,
                                                      @Field("min_prob") double min_prob,
                                                      @Field("eps_prob") double eps_prob,
                                                      @Field("compute_metrics") boolean compute_metrics,
                                                      @Field("seed") long seed,
                                                      @Field("model_id") String model_id,
                                                      @Field("training_frame") String training_frame,
                                                      @Field("validation_frame") String validation_frame,
                                                      @Field("nfolds") int nfolds,
                                                      @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                                      @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                                      @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                                      @Field("response_column") String response_column,
                                                      @Field("weights_column") String weights_column,
                                                      @Field("offset_column") String offset_column,
                                                      @Field("fold_column") String fold_column,
                                                      @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                                      @Field("ignored_columns") String[] ignored_columns,
                                                      @Field("ignore_const_cols") boolean ignore_const_cols,
                                                      @Field("score_each_iteration") boolean score_each_iteration,
                                                      @Field("checkpoint") String checkpoint,
                                                      @Field("stopping_rounds") int stopping_rounds,
                                                      @Field("max_runtime_secs") double max_runtime_secs,
                                                      @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                                      @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a PCA model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/pca")
    Call<PCAV3> train_pca(@Field("transform") DataInfoTransformType transform,
                          @Field("pca_method") PcaPCAModelPCAParametersMethod pca_method,
                          @Field("k") int k,
                          @Field("max_iterations") int max_iterations,
                          @Field("seed") long seed,
                          @Field("use_all_factor_levels") boolean use_all_factor_levels,
                          @Field("compute_metrics") boolean compute_metrics,
                          @Field("impute_missing") boolean impute_missing,
                          @Field("model_id") String model_id,
                          @Field("training_frame") String training_frame,
                          @Field("validation_frame") String validation_frame,
                          @Field("nfolds") int nfolds,
                          @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                          @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                          @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                          @Field("response_column") String response_column,
                          @Field("weights_column") String weights_column,
                          @Field("offset_column") String offset_column,
                          @Field("fold_column") String fold_column,
                          @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                          @Field("ignored_columns") String[] ignored_columns,
                          @Field("ignore_const_cols") boolean ignore_const_cols,
                          @Field("score_each_iteration") boolean score_each_iteration,
                          @Field("checkpoint") String checkpoint,
                          @Field("stopping_rounds") int stopping_rounds,
                          @Field("max_runtime_secs") double max_runtime_secs,
                          @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                          @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of PCA model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/pca/parameters")
    Call<PCAV3> validate_parameters_pca(@Field("transform") DataInfoTransformType transform,
                                        @Field("pca_method") PcaPCAModelPCAParametersMethod pca_method,
                                        @Field("k") int k,
                                        @Field("max_iterations") int max_iterations,
                                        @Field("seed") long seed,
                                        @Field("use_all_factor_levels") boolean use_all_factor_levels,
                                        @Field("compute_metrics") boolean compute_metrics,
                                        @Field("impute_missing") boolean impute_missing,
                                        @Field("model_id") String model_id,
                                        @Field("training_frame") String training_frame,
                                        @Field("validation_frame") String validation_frame,
                                        @Field("nfolds") int nfolds,
                                        @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                        @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                        @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                        @Field("response_column") String response_column,
                                        @Field("weights_column") String weights_column,
                                        @Field("offset_column") String offset_column,
                                        @Field("fold_column") String fold_column,
                                        @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                        @Field("ignored_columns") String[] ignored_columns,
                                        @Field("ignore_const_cols") boolean ignore_const_cols,
                                        @Field("score_each_iteration") boolean score_each_iteration,
                                        @Field("checkpoint") String checkpoint,
                                        @Field("stopping_rounds") int stopping_rounds,
                                        @Field("max_runtime_secs") double max_runtime_secs,
                                        @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                        @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a SVD model. */
    @FormUrlEncoded
    @POST("/99/ModelBuilders/svd")
    Call<SVDV99> train_svd(@Field("transform") DataInfoTransformType transform,
                           @Field("svd_method") SvdSVDModelSVDParametersMethod svd_method,
                           @Field("nv") int nv,
                           @Field("max_iterations") int max_iterations,
                           @Field("seed") long seed,
                           @Field("keep_u") boolean keep_u,
                           @Field("u_name") String u_name,
                           @Field("use_all_factor_levels") boolean use_all_factor_levels,
                           @Field("model_id") String model_id,
                           @Field("training_frame") String training_frame,
                           @Field("validation_frame") String validation_frame,
                           @Field("nfolds") int nfolds,
                           @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                           @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                           @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                           @Field("response_column") String response_column,
                           @Field("weights_column") String weights_column,
                           @Field("offset_column") String offset_column,
                           @Field("fold_column") String fold_column,
                           @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                           @Field("ignored_columns") String[] ignored_columns,
                           @Field("ignore_const_cols") boolean ignore_const_cols,
                           @Field("score_each_iteration") boolean score_each_iteration,
                           @Field("checkpoint") String checkpoint,
                           @Field("stopping_rounds") int stopping_rounds,
                           @Field("max_runtime_secs") double max_runtime_secs,
                           @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                           @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of SVD model builder parameters. */
    @FormUrlEncoded
    @POST("/99/ModelBuilders/svd/parameters")
    Call<SVDV99> validate_parameters_svd(@Field("transform") DataInfoTransformType transform,
                                         @Field("svd_method") SvdSVDModelSVDParametersMethod svd_method,
                                         @Field("nv") int nv,
                                         @Field("max_iterations") int max_iterations,
                                         @Field("seed") long seed,
                                         @Field("keep_u") boolean keep_u,
                                         @Field("u_name") String u_name,
                                         @Field("use_all_factor_levels") boolean use_all_factor_levels,
                                         @Field("model_id") String model_id,
                                         @Field("training_frame") String training_frame,
                                         @Field("validation_frame") String validation_frame,
                                         @Field("nfolds") int nfolds,
                                         @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                         @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                         @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                         @Field("response_column") String response_column,
                                         @Field("weights_column") String weights_column,
                                         @Field("offset_column") String offset_column,
                                         @Field("fold_column") String fold_column,
                                         @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                         @Field("ignored_columns") String[] ignored_columns,
                                         @Field("ignore_const_cols") boolean ignore_const_cols,
                                         @Field("score_each_iteration") boolean score_each_iteration,
                                         @Field("checkpoint") String checkpoint,
                                         @Field("stopping_rounds") int stopping_rounds,
                                         @Field("max_runtime_secs") double max_runtime_secs,
                                         @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                         @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a DRF model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/drf")
    Call<DRFV3> train_drf(@Field("mtries") int mtries,
                          @Field("binomial_double_trees") boolean binomial_double_trees,
                          @Field("balance_classes") boolean balance_classes,
                          @Field("class_sampling_factors") float[] class_sampling_factors,
                          @Field("max_after_balance_size") float max_after_balance_size,
                          @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                          @Field("max_hit_ratio_k") int max_hit_ratio_k,
                          @Field("ntrees") int ntrees,
                          @Field("max_depth") int max_depth,
                          @Field("min_rows") double min_rows,
                          @Field("nbins") int nbins,
                          @Field("nbins_top_level") int nbins_top_level,
                          @Field("nbins_cats") int nbins_cats,
                          @Field("r2_stopping") double r2_stopping,
                          @Field("seed") long seed,
                          @Field("build_tree_one_node") boolean build_tree_one_node,
                          @Field("sample_rate") double sample_rate,
                          @Field("sample_rate_per_class") double[] sample_rate_per_class,
                          @Field("col_sample_rate_per_tree") double col_sample_rate_per_tree,
                          @Field("col_sample_rate_change_per_level") double col_sample_rate_change_per_level,
                          @Field("score_tree_interval") int score_tree_interval,
                          @Field("min_split_improvement") double min_split_improvement,
                          @Field("histogram_type") TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type,
                          @Field("model_id") String model_id,
                          @Field("training_frame") String training_frame,
                          @Field("validation_frame") String validation_frame,
                          @Field("nfolds") int nfolds,
                          @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                          @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                          @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                          @Field("response_column") String response_column,
                          @Field("weights_column") String weights_column,
                          @Field("offset_column") String offset_column,
                          @Field("fold_column") String fold_column,
                          @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                          @Field("ignored_columns") String[] ignored_columns,
                          @Field("ignore_const_cols") boolean ignore_const_cols,
                          @Field("score_each_iteration") boolean score_each_iteration,
                          @Field("checkpoint") String checkpoint,
                          @Field("stopping_rounds") int stopping_rounds,
                          @Field("max_runtime_secs") double max_runtime_secs,
                          @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                          @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of DRF model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/drf/parameters")
    Call<DRFV3> validate_parameters_drf(@Field("mtries") int mtries,
                                        @Field("binomial_double_trees") boolean binomial_double_trees,
                                        @Field("balance_classes") boolean balance_classes,
                                        @Field("class_sampling_factors") float[] class_sampling_factors,
                                        @Field("max_after_balance_size") float max_after_balance_size,
                                        @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                                        @Field("max_hit_ratio_k") int max_hit_ratio_k,
                                        @Field("ntrees") int ntrees,
                                        @Field("max_depth") int max_depth,
                                        @Field("min_rows") double min_rows,
                                        @Field("nbins") int nbins,
                                        @Field("nbins_top_level") int nbins_top_level,
                                        @Field("nbins_cats") int nbins_cats,
                                        @Field("r2_stopping") double r2_stopping,
                                        @Field("seed") long seed,
                                        @Field("build_tree_one_node") boolean build_tree_one_node,
                                        @Field("sample_rate") double sample_rate,
                                        @Field("sample_rate_per_class") double[] sample_rate_per_class,
                                        @Field("col_sample_rate_per_tree") double col_sample_rate_per_tree,
                                        @Field("col_sample_rate_change_per_level") double col_sample_rate_change_per_level,
                                        @Field("score_tree_interval") int score_tree_interval,
                                        @Field("min_split_improvement") double min_split_improvement,
                                        @Field("histogram_type") TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type,
                                        @Field("model_id") String model_id,
                                        @Field("training_frame") String training_frame,
                                        @Field("validation_frame") String validation_frame,
                                        @Field("nfolds") int nfolds,
                                        @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                        @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                        @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                        @Field("response_column") String response_column,
                                        @Field("weights_column") String weights_column,
                                        @Field("offset_column") String offset_column,
                                        @Field("fold_column") String fold_column,
                                        @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                        @Field("ignored_columns") String[] ignored_columns,
                                        @Field("ignore_const_cols") boolean ignore_const_cols,
                                        @Field("score_each_iteration") boolean score_each_iteration,
                                        @Field("checkpoint") String checkpoint,
                                        @Field("stopping_rounds") int stopping_rounds,
                                        @Field("max_runtime_secs") double max_runtime_secs,
                                        @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                        @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a GBM model. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/gbm")
    Call<GBMV3> train_gbm(@Field("learn_rate") double learn_rate,
                          @Field("learn_rate_annealing") double learn_rate_annealing,
                          @Field("distribution") DistributionFamily distribution,
                          @Field("quantile_alpha") double quantile_alpha,
                          @Field("tweedie_power") double tweedie_power,
                          @Field("col_sample_rate") double col_sample_rate,
                          @Field("max_abs_leafnode_pred") double max_abs_leafnode_pred,
                          @Field("balance_classes") boolean balance_classes,
                          @Field("class_sampling_factors") float[] class_sampling_factors,
                          @Field("max_after_balance_size") float max_after_balance_size,
                          @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                          @Field("max_hit_ratio_k") int max_hit_ratio_k,
                          @Field("ntrees") int ntrees,
                          @Field("max_depth") int max_depth,
                          @Field("min_rows") double min_rows,
                          @Field("nbins") int nbins,
                          @Field("nbins_top_level") int nbins_top_level,
                          @Field("nbins_cats") int nbins_cats,
                          @Field("r2_stopping") double r2_stopping,
                          @Field("seed") long seed,
                          @Field("build_tree_one_node") boolean build_tree_one_node,
                          @Field("sample_rate") double sample_rate,
                          @Field("sample_rate_per_class") double[] sample_rate_per_class,
                          @Field("col_sample_rate_per_tree") double col_sample_rate_per_tree,
                          @Field("col_sample_rate_change_per_level") double col_sample_rate_change_per_level,
                          @Field("score_tree_interval") int score_tree_interval,
                          @Field("min_split_improvement") double min_split_improvement,
                          @Field("histogram_type") TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type,
                          @Field("model_id") String model_id,
                          @Field("training_frame") String training_frame,
                          @Field("validation_frame") String validation_frame,
                          @Field("nfolds") int nfolds,
                          @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                          @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                          @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                          @Field("response_column") String response_column,
                          @Field("weights_column") String weights_column,
                          @Field("offset_column") String offset_column,
                          @Field("fold_column") String fold_column,
                          @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                          @Field("ignored_columns") String[] ignored_columns,
                          @Field("ignore_const_cols") boolean ignore_const_cols,
                          @Field("score_each_iteration") boolean score_each_iteration,
                          @Field("checkpoint") String checkpoint,
                          @Field("stopping_rounds") int stopping_rounds,
                          @Field("max_runtime_secs") double max_runtime_secs,
                          @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                          @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of GBM model builder parameters. */
    @FormUrlEncoded
    @POST("/3/ModelBuilders/gbm/parameters")
    Call<GBMV3> validate_parameters_gbm(@Field("learn_rate") double learn_rate,
                                        @Field("learn_rate_annealing") double learn_rate_annealing,
                                        @Field("distribution") DistributionFamily distribution,
                                        @Field("quantile_alpha") double quantile_alpha,
                                        @Field("tweedie_power") double tweedie_power,
                                        @Field("col_sample_rate") double col_sample_rate,
                                        @Field("max_abs_leafnode_pred") double max_abs_leafnode_pred,
                                        @Field("balance_classes") boolean balance_classes,
                                        @Field("class_sampling_factors") float[] class_sampling_factors,
                                        @Field("max_after_balance_size") float max_after_balance_size,
                                        @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
                                        @Field("max_hit_ratio_k") int max_hit_ratio_k,
                                        @Field("ntrees") int ntrees,
                                        @Field("max_depth") int max_depth,
                                        @Field("min_rows") double min_rows,
                                        @Field("nbins") int nbins,
                                        @Field("nbins_top_level") int nbins_top_level,
                                        @Field("nbins_cats") int nbins_cats,
                                        @Field("r2_stopping") double r2_stopping,
                                        @Field("seed") long seed,
                                        @Field("build_tree_one_node") boolean build_tree_one_node,
                                        @Field("sample_rate") double sample_rate,
                                        @Field("sample_rate_per_class") double[] sample_rate_per_class,
                                        @Field("col_sample_rate_per_tree") double col_sample_rate_per_tree,
                                        @Field("col_sample_rate_change_per_level") double col_sample_rate_change_per_level,
                                        @Field("score_tree_interval") int score_tree_interval,
                                        @Field("min_split_improvement") double min_split_improvement,
                                        @Field("histogram_type") TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type,
                                        @Field("model_id") String model_id,
                                        @Field("training_frame") String training_frame,
                                        @Field("validation_frame") String validation_frame,
                                        @Field("nfolds") int nfolds,
                                        @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                        @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                        @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                        @Field("response_column") String response_column,
                                        @Field("weights_column") String weights_column,
                                        @Field("offset_column") String offset_column,
                                        @Field("fold_column") String fold_column,
                                        @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                        @Field("ignored_columns") String[] ignored_columns,
                                        @Field("ignore_const_cols") boolean ignore_const_cols,
                                        @Field("score_each_iteration") boolean score_each_iteration,
                                        @Field("checkpoint") String checkpoint,
                                        @Field("stopping_rounds") int stopping_rounds,
                                        @Field("max_runtime_secs") double max_runtime_secs,
                                        @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                        @Field("stopping_tolerance") double stopping_tolerance);

    /** Train a Aggregator model. */
    @FormUrlEncoded
    @POST("/99/ModelBuilders/aggregator")
    Call<AggregatorV99> train_aggregator(@Field("radius_scale") double radius_scale,
                                         @Field("transform") DataInfoTransformType transform,
                                         @Field("pca_method") PcaPCAModelPCAParametersMethod pca_method,
                                         @Field("k") int k,
                                         @Field("max_iterations") int max_iterations,
                                         @Field("seed") long seed,
                                         @Field("use_all_factor_levels") boolean use_all_factor_levels,
                                         @Field("model_id") String model_id,
                                         @Field("training_frame") String training_frame,
                                         @Field("validation_frame") String validation_frame,
                                         @Field("nfolds") int nfolds,
                                         @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                         @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                         @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                         @Field("response_column") String response_column,
                                         @Field("weights_column") String weights_column,
                                         @Field("offset_column") String offset_column,
                                         @Field("fold_column") String fold_column,
                                         @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                         @Field("ignored_columns") String[] ignored_columns,
                                         @Field("ignore_const_cols") boolean ignore_const_cols,
                                         @Field("score_each_iteration") boolean score_each_iteration,
                                         @Field("checkpoint") String checkpoint,
                                         @Field("stopping_rounds") int stopping_rounds,
                                         @Field("max_runtime_secs") double max_runtime_secs,
                                         @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                         @Field("stopping_tolerance") double stopping_tolerance);

    /** Validate a set of Aggregator model builder parameters. */
    @FormUrlEncoded
    @POST("/99/ModelBuilders/aggregator/parameters")
    Call<AggregatorV99> validate_parameters_aggregator(@Field("radius_scale") double radius_scale,
                                                       @Field("transform") DataInfoTransformType transform,
                                                       @Field("pca_method") PcaPCAModelPCAParametersMethod pca_method,
                                                       @Field("k") int k,
                                                       @Field("max_iterations") int max_iterations,
                                                       @Field("seed") long seed,
                                                       @Field("use_all_factor_levels") boolean use_all_factor_levels,
                                                       @Field("model_id") String model_id,
                                                       @Field("training_frame") String training_frame,
                                                       @Field("validation_frame") String validation_frame,
                                                       @Field("nfolds") int nfolds,
                                                       @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                                       @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                                       @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                                       @Field("response_column") String response_column,
                                                       @Field("weights_column") String weights_column,
                                                       @Field("offset_column") String offset_column,
                                                       @Field("fold_column") String fold_column,
                                                       @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                                       @Field("ignored_columns") String[] ignored_columns,
                                                       @Field("ignore_const_cols") boolean ignore_const_cols,
                                                       @Field("score_each_iteration") boolean score_each_iteration,
                                                       @Field("checkpoint") String checkpoint,
                                                       @Field("stopping_rounds") int stopping_rounds,
                                                       @Field("max_runtime_secs") double max_runtime_secs,
                                                       @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                                       @Field("stopping_tolerance") double stopping_tolerance);

    public static class Helper {
    /** Train a DeepLearning model. */
    public static Call<DeepLearningV3> train_deeplearning(ModelBuilders modelBuildersService, DeepLearningParametersV3 parameters)  {
        return modelBuildersService.train_deeplearning(parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.overwrite_with_best_model, parameters.autoencoder, parameters.use_all_factor_levels, parameters.standardize, parameters.activation, parameters.hidden, parameters.epochs, parameters.train_samples_per_iteration, parameters.target_ratio_comm_to_comp, parameters.seed, parameters.adaptive_rate, parameters.rho, parameters.epsilon, parameters.rate, parameters.rate_annealing, parameters.rate_decay, parameters.momentum_start, parameters.momentum_ramp, parameters.momentum_stable, parameters.nesterov_accelerated_gradient, parameters.input_dropout_ratio, parameters.hidden_dropout_ratios, parameters.l1, parameters.l2, parameters.max_w2, parameters.initial_weight_distribution, parameters.initial_weight_scale, (parameters.initial_weights == null ? null : key_array_to_string_array(parameters.initial_weights)), (parameters.initial_biases == null ? null : key_array_to_string_array(parameters.initial_biases)), parameters.loss, parameters.distribution, parameters.tweedie_power, parameters.quantile_alpha, parameters.score_interval, parameters.score_training_samples, parameters.score_validation_samples, parameters.score_duty_cycle, parameters.classification_stop, parameters.regression_stop, parameters.quiet_mode, parameters.score_validation_sampling, parameters.diagnostics, parameters.variable_importances, parameters.fast_mode, parameters.force_load_balance, parameters.replicate_training_data, parameters.single_node_mode, parameters.shuffle_training_data, parameters.missing_values_handling, parameters.sparse, parameters.col_major, parameters.average_activation, parameters.sparsity_beta, parameters.max_categorical_features, parameters.reproducible, parameters.export_weights_and_biases, parameters.mini_batch_size, parameters.elastic_averaging, parameters.elastic_averaging_moving_rate, parameters.elastic_averaging_regularization, (parameters.pretrained_autoencoder == null ? null : parameters.pretrained_autoencoder.name), (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of DeepLearning model builder parameters. */
    public static Call<DeepLearningV3> validate_parameters_deeplearning(ModelBuilders modelBuildersService, DeepLearningParametersV3 parameters)  {
        return modelBuildersService.validate_parameters_deeplearning(parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.overwrite_with_best_model, parameters.autoencoder, parameters.use_all_factor_levels, parameters.standardize, parameters.activation, parameters.hidden, parameters.epochs, parameters.train_samples_per_iteration, parameters.target_ratio_comm_to_comp, parameters.seed, parameters.adaptive_rate, parameters.rho, parameters.epsilon, parameters.rate, parameters.rate_annealing, parameters.rate_decay, parameters.momentum_start, parameters.momentum_ramp, parameters.momentum_stable, parameters.nesterov_accelerated_gradient, parameters.input_dropout_ratio, parameters.hidden_dropout_ratios, parameters.l1, parameters.l2, parameters.max_w2, parameters.initial_weight_distribution, parameters.initial_weight_scale, (parameters.initial_weights == null ? null : key_array_to_string_array(parameters.initial_weights)), (parameters.initial_biases == null ? null : key_array_to_string_array(parameters.initial_biases)), parameters.loss, parameters.distribution, parameters.tweedie_power, parameters.quantile_alpha, parameters.score_interval, parameters.score_training_samples, parameters.score_validation_samples, parameters.score_duty_cycle, parameters.classification_stop, parameters.regression_stop, parameters.quiet_mode, parameters.score_validation_sampling, parameters.diagnostics, parameters.variable_importances, parameters.fast_mode, parameters.force_load_balance, parameters.replicate_training_data, parameters.single_node_mode, parameters.shuffle_training_data, parameters.missing_values_handling, parameters.sparse, parameters.col_major, parameters.average_activation, parameters.sparsity_beta, parameters.max_categorical_features, parameters.reproducible, parameters.export_weights_and_biases, parameters.mini_batch_size, parameters.elastic_averaging, parameters.elastic_averaging_moving_rate, parameters.elastic_averaging_regularization, (parameters.pretrained_autoencoder == null ? null : parameters.pretrained_autoencoder.name), (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a GLM model. */
    public static Call<GLMV3> train_glm(ModelBuilders modelBuildersService, GLMParametersV3 parameters)  {
        return modelBuildersService.train_glm(parameters.family, parameters.tweedie_variance_power, parameters.tweedie_link_power, parameters.solver, parameters.alpha, parameters.lambda, parameters.lambda_search, parameters.nlambdas, parameters.standardize, parameters.missing_values_handling, parameters.non_negative, parameters.max_iterations, parameters.beta_epsilon, parameters.objective_epsilon, parameters.gradient_epsilon, parameters.obj_reg, parameters.link, parameters.intercept, parameters.prior, parameters.lambda_min_ratio, (parameters.beta_constraints == null ? null : parameters.beta_constraints.name), parameters.max_active_predictors, parameters.interactions, parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.compute_p_values, parameters.remove_collinear_columns, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of GLM model builder parameters. */
    public static Call<GLMV3> validate_parameters_glm(ModelBuilders modelBuildersService, GLMParametersV3 parameters)  {
        return modelBuildersService.validate_parameters_glm(parameters.family, parameters.tweedie_variance_power, parameters.tweedie_link_power, parameters.solver, parameters.alpha, parameters.lambda, parameters.lambda_search, parameters.nlambdas, parameters.standardize, parameters.missing_values_handling, parameters.non_negative, parameters.max_iterations, parameters.beta_epsilon, parameters.objective_epsilon, parameters.gradient_epsilon, parameters.obj_reg, parameters.link, parameters.intercept, parameters.prior, parameters.lambda_min_ratio, (parameters.beta_constraints == null ? null : parameters.beta_constraints.name), parameters.max_active_predictors, parameters.interactions, parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.compute_p_values, parameters.remove_collinear_columns, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a GLRM model. */
    public static Call<GLRMV3> train_glrm(ModelBuilders modelBuildersService, GLRMParametersV3 parameters)  {
        return modelBuildersService.train_glrm(parameters.transform, parameters.k, parameters.loss, parameters.multi_loss, parameters.loss_by_col, parameters.loss_by_col_idx, parameters.period, parameters.regularization_x, parameters.regularization_y, parameters.gamma_x, parameters.gamma_y, parameters.max_iterations, parameters.max_updates, parameters.init_step_size, parameters.min_step_size, parameters.seed, parameters.init, parameters.svd_method, (parameters.user_y == null ? null : parameters.user_y.name), (parameters.user_x == null ? null : parameters.user_x.name), parameters.loading_name, parameters.expand_user_y, parameters.impute_original, parameters.recover_svd, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of GLRM model builder parameters. */
    public static Call<GLRMV3> validate_parameters_glrm(ModelBuilders modelBuildersService, GLRMParametersV3 parameters)  {
        return modelBuildersService.validate_parameters_glrm(parameters.transform, parameters.k, parameters.loss, parameters.multi_loss, parameters.loss_by_col, parameters.loss_by_col_idx, parameters.period, parameters.regularization_x, parameters.regularization_y, parameters.gamma_x, parameters.gamma_y, parameters.max_iterations, parameters.max_updates, parameters.init_step_size, parameters.min_step_size, parameters.seed, parameters.init, parameters.svd_method, (parameters.user_y == null ? null : parameters.user_y.name), (parameters.user_x == null ? null : parameters.user_x.name), parameters.loading_name, parameters.expand_user_y, parameters.impute_original, parameters.recover_svd, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a KMeans model. */
    public static Call<KMeansV3> train_kmeans(ModelBuilders modelBuildersService, KMeansParametersV3 parameters)  {
        return modelBuildersService.train_kmeans((parameters.user_points == null ? null : parameters.user_points.name), parameters.max_iterations, parameters.standardize, parameters.seed, parameters.init, parameters.k, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of KMeans model builder parameters. */
    public static Call<KMeansV3> validate_parameters_kmeans(ModelBuilders modelBuildersService, KMeansParametersV3 parameters)  {
        return modelBuildersService.validate_parameters_kmeans((parameters.user_points == null ? null : parameters.user_points.name), parameters.max_iterations, parameters.standardize, parameters.seed, parameters.init, parameters.k, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a NaiveBayes model. */
    public static Call<NaiveBayesV3> train_naivebayes(ModelBuilders modelBuildersService, NaiveBayesParametersV3 parameters)  {
        return modelBuildersService.train_naivebayes(parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.laplace, parameters.min_sdev, parameters.eps_sdev, parameters.min_prob, parameters.eps_prob, parameters.compute_metrics, parameters.seed, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of NaiveBayes model builder parameters. */
    public static Call<NaiveBayesV3> validate_parameters_naivebayes(ModelBuilders modelBuildersService, NaiveBayesParametersV3 parameters)  {
        return modelBuildersService.validate_parameters_naivebayes(parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.laplace, parameters.min_sdev, parameters.eps_sdev, parameters.min_prob, parameters.eps_prob, parameters.compute_metrics, parameters.seed, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a PCA model. */
    public static Call<PCAV3> train_pca(ModelBuilders modelBuildersService, PCAParametersV3 parameters)  {
        return modelBuildersService.train_pca(parameters.transform, parameters.pca_method, parameters.k, parameters.max_iterations, parameters.seed, parameters.use_all_factor_levels, parameters.compute_metrics, parameters.impute_missing, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of PCA model builder parameters. */
    public static Call<PCAV3> validate_parameters_pca(ModelBuilders modelBuildersService, PCAParametersV3 parameters)  {
        return modelBuildersService.validate_parameters_pca(parameters.transform, parameters.pca_method, parameters.k, parameters.max_iterations, parameters.seed, parameters.use_all_factor_levels, parameters.compute_metrics, parameters.impute_missing, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a SVD model. */
    public static Call<SVDV99> train_svd(ModelBuilders modelBuildersService, SVDParametersV99 parameters)  {
        return modelBuildersService.train_svd(parameters.transform, parameters.svd_method, parameters.nv, parameters.max_iterations, parameters.seed, parameters.keep_u, parameters.u_name, parameters.use_all_factor_levels, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of SVD model builder parameters. */
    public static Call<SVDV99> validate_parameters_svd(ModelBuilders modelBuildersService, SVDParametersV99 parameters)  {
        return modelBuildersService.validate_parameters_svd(parameters.transform, parameters.svd_method, parameters.nv, parameters.max_iterations, parameters.seed, parameters.keep_u, parameters.u_name, parameters.use_all_factor_levels, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a DRF model. */
    public static Call<DRFV3> train_drf(ModelBuilders modelBuildersService, DRFParametersV3 parameters)  {
        return modelBuildersService.train_drf(parameters.mtries, parameters.binomial_double_trees, parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.ntrees, parameters.max_depth, parameters.min_rows, parameters.nbins, parameters.nbins_top_level, parameters.nbins_cats, parameters.r2_stopping, parameters.seed, parameters.build_tree_one_node, parameters.sample_rate, parameters.sample_rate_per_class, parameters.col_sample_rate_per_tree, parameters.col_sample_rate_change_per_level, parameters.score_tree_interval, parameters.min_split_improvement, parameters.histogram_type, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of DRF model builder parameters. */
    public static Call<DRFV3> validate_parameters_drf(ModelBuilders modelBuildersService, DRFParametersV3 parameters)  {
        return modelBuildersService.validate_parameters_drf(parameters.mtries, parameters.binomial_double_trees, parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.ntrees, parameters.max_depth, parameters.min_rows, parameters.nbins, parameters.nbins_top_level, parameters.nbins_cats, parameters.r2_stopping, parameters.seed, parameters.build_tree_one_node, parameters.sample_rate, parameters.sample_rate_per_class, parameters.col_sample_rate_per_tree, parameters.col_sample_rate_change_per_level, parameters.score_tree_interval, parameters.min_split_improvement, parameters.histogram_type, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a GBM model. */
    public static Call<GBMV3> train_gbm(ModelBuilders modelBuildersService, GBMParametersV3 parameters)  {
        return modelBuildersService.train_gbm(parameters.learn_rate, parameters.learn_rate_annealing, parameters.distribution, parameters.quantile_alpha, parameters.tweedie_power, parameters.col_sample_rate, parameters.max_abs_leafnode_pred, parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.ntrees, parameters.max_depth, parameters.min_rows, parameters.nbins, parameters.nbins_top_level, parameters.nbins_cats, parameters.r2_stopping, parameters.seed, parameters.build_tree_one_node, parameters.sample_rate, parameters.sample_rate_per_class, parameters.col_sample_rate_per_tree, parameters.col_sample_rate_change_per_level, parameters.score_tree_interval, parameters.min_split_improvement, parameters.histogram_type, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of GBM model builder parameters. */
    public static Call<GBMV3> validate_parameters_gbm(ModelBuilders modelBuildersService, GBMParametersV3 parameters)  {
        return modelBuildersService.validate_parameters_gbm(parameters.learn_rate, parameters.learn_rate_annealing, parameters.distribution, parameters.quantile_alpha, parameters.tweedie_power, parameters.col_sample_rate, parameters.max_abs_leafnode_pred, parameters.balance_classes, parameters.class_sampling_factors, parameters.max_after_balance_size, parameters.max_confusion_matrix_size, parameters.max_hit_ratio_k, parameters.ntrees, parameters.max_depth, parameters.min_rows, parameters.nbins, parameters.nbins_top_level, parameters.nbins_cats, parameters.r2_stopping, parameters.seed, parameters.build_tree_one_node, parameters.sample_rate, parameters.sample_rate_per_class, parameters.col_sample_rate_per_tree, parameters.col_sample_rate_change_per_level, parameters.score_tree_interval, parameters.min_split_improvement, parameters.histogram_type, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Train a Aggregator model. */
    public static Call<AggregatorV99> train_aggregator(ModelBuilders modelBuildersService, AggregatorParametersV99 parameters)  {
        return modelBuildersService.train_aggregator(parameters.radius_scale, parameters.transform, parameters.pca_method, parameters.k, parameters.max_iterations, parameters.seed, parameters.use_all_factor_levels, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Validate a set of Aggregator model builder parameters. */
    public static Call<AggregatorV99> validate_parameters_aggregator(ModelBuilders modelBuildersService, AggregatorParametersV99 parameters)  {
        return modelBuildersService.validate_parameters_aggregator(parameters.radius_scale, parameters.transform, parameters.pca_method, parameters.k, parameters.max_iterations, parameters.seed, parameters.use_all_factor_levels, (parameters.model_id == null ? null : parameters.model_id.name), (parameters.training_frame == null ? null : parameters.training_frame.name), (parameters.validation_frame == null ? null : parameters.validation_frame.name), parameters.nfolds, parameters.keep_cross_validation_predictions, parameters.keep_cross_validation_fold_assignment, parameters.parallelize_cross_validation, (parameters.response_column == null ? null : parameters.response_column.column_name), (parameters.weights_column == null ? null : parameters.weights_column.column_name), (parameters.offset_column == null ? null : parameters.offset_column.column_name), (parameters.fold_column == null ? null : parameters.fold_column.column_name), parameters.fold_assignment, parameters.ignored_columns, parameters.ignore_const_cols, parameters.score_each_iteration, (parameters.checkpoint == null ? null : parameters.checkpoint.name), parameters.stopping_rounds, parameters.max_runtime_secs, parameters.stopping_metric, parameters.stopping_tolerance);
    }
    /** Return an array of Strings for an array of keys. */
    public static String[] key_array_to_string_array(KeyV3[] keys) {
        if (null == keys) return null;
        String[] ids = new String[keys.length];
        int i = 0;
        for (KeyV3 key : keys) ids[i++] = key.name;
        return ids;
    }
    }
}
