package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface ParseSetup {
    /** Guess the parameters for parsing raw byte-oriented data into an H2O Frame. */
    @FormUrlEncoded
    @POST("/3/ParseSetup")
    Call<ParseSetupV3> guessSetup(@Field("source_frames") String[] source_frames,
                                  @Field("parse_type") ApiParseTypeValuesProvider parse_type,
                                  @Field("separator") byte separator,
                                  @Field("single_quotes") boolean single_quotes,
                                  @Field("check_header") int check_header,
                                  @Field("column_names") String[] column_names,
                                  @Field("column_types") String[] column_types,
                                  @Field("na_strings") String[][] na_strings,
                                  @Field("column_name_filter") String column_name_filter,
                                  @Field("column_offset") int column_offset,
                                  @Field("column_count") int column_count,
                                  @Field("total_filtered_column_count") int total_filtered_column_count,
                                  @Field("_exclude_fields") String _exclude_fields);
}
