package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Predictions {
    /** Score (generate predictions) for the specified Frame with the specified Model.  Both the Frame of predictions and the metrics will be returned. */
    @FormUrlEncoded
    @POST("/3/Predictions/models/{model}/frames/{frame}")
    Call<ModelMetricsListSchemaV3> predict(@Path("model") String model,
                                           @Path("frame") String frame,
                                           @Field("predictions_frame") String predictions_frame,
                                           @Field("reconstruction_error") boolean reconstruction_error,
                                           @Field("reconstruction_error_per_feature") boolean reconstruction_error_per_feature,
                                           @Field("deep_features_hidden_layer") int deep_features_hidden_layer,
                                           @Field("reconstruct_train") boolean reconstruct_train,
                                           @Field("project_archetypes") boolean project_archetypes,
                                           @Field("reverse_transform") boolean reverse_transform,
                                           @Field("leaf_node_assignment") boolean leaf_node_assignment,
                                           @Field("exemplar_index") int exemplar_index,
                                           @Field("_exclude_fields") String _exclude_fields);

    /** Score (generate predictions) for the specified Frame with the specified Model.  Both the Frame of predictions and the metrics will be returned. */
    @FormUrlEncoded
    @POST("/4/Predictions/models/{model}/frames/{frame}")
    Call<JobV3> predict2(@Path("model") String model,
                         @Path("frame") String frame,
                         @Field("predictions_frame") String predictions_frame,
                         @Field("reconstruction_error") boolean reconstruction_error,
                         @Field("reconstruction_error_per_feature") boolean reconstruction_error_per_feature,
                         @Field("deep_features_hidden_layer") int deep_features_hidden_layer,
                         @Field("reconstruct_train") boolean reconstruct_train,
                         @Field("project_archetypes") boolean project_archetypes,
                         @Field("reverse_transform") boolean reverse_transform,
                         @Field("leaf_node_assignment") boolean leaf_node_assignment,
                         @Field("exemplar_index") int exemplar_index,
                         @Field("_exclude_fields") String _exclude_fields);
}
