package water.bindings.pojos;

import com.google.gson.Gson;

public class DCTTransformerV3 extends RequestSchema {
    /** Dataset */
    public FrameKeyV3 dataset;

    /** Destination Frame ID */
    public FrameKeyV3 destination_frame;

    /** Dimensions of the input array: Height, Width, Depth (Nx1x1 for 1D, NxMx1 for 2D) */
    public int[] dimensions;

    /** Whether to do the inverse transform */
    public boolean inverse;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public DCTTransformerV3() {
        dataset = null;
        destination_frame = null;
        dimensions = null;
        inverse = false;
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
