package water.bindings.pojos;

import com.google.gson.Gson;

public class DRFParametersV3 extends SharedTreeParametersV3 {
    /** Number of variables randomly sampled as candidates at each split. If set to -1, defaults to sqrt{p} for classification and p/3 for regression (where p is the # of predictors */
    public int mtries;

    /** For binary classification: Build 2x as many trees (one per class) - can lead to higher accuracy. */
    public boolean binomial_double_trees;

    /* INHERITED: Balance training data class counts via over/under-sampling (for imbalanced data). 
    public boolean balance_classes = false;
     */

    /* INHERITED: Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes. 
    public float[] class_sampling_factors = null;
     */

    /* INHERITED: Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes. 
    public float max_after_balance_size = 5.0f;
     */

    /* INHERITED: Maximum size (# classes) for confusion matrices to be printed in the Logs 
    public int max_confusion_matrix_size = 20;
     */

    /* INHERITED: Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable) 
    public int max_hit_ratio_k = 0;
     */

    /* INHERITED: Number of trees. 
    public int ntrees = 50;
     */

    /* INHERITED: Maximum tree depth. 
    public int max_depth = 20;
     */

    /* INHERITED: Fewest allowed (weighted) observations in a leaf (in R called 'nodesize'). 
    public double min_rows = 1.0;
     */

    /* INHERITED: For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the best point 
    public int nbins = 20;
     */

    /* INHERITED: For numerical columns (real/int), build a histogram of (at most) this many bins at the root level, then decrease by factor of two per level 
    public int nbins_top_level = 1024;
     */

    /* INHERITED: For categorical columns (factors), build a histogram of this many bins, then split at the best point. Higher values can lead to more overfitting. 
    public int nbins_cats = 1024;
     */

    /* INHERITED: Stop making trees when the R^2 metric equals or exceeds this 
    public double r2_stopping = 0.999999;
     */

    /* INHERITED: Seed for pseudo random number generator (if applicable) 
    public long seed = -1L;
     */

    /* INHERITED: Run on one node only; no network overhead but fewer cpus used.  Suitable for small datasets. 
    public boolean build_tree_one_node = false;
     */

    /* INHERITED: Row sample rate per tree (from 0.0 to 1.0) 
    public double sample_rate = 0.632000029087;
     */

    /* INHERITED: Row sample rate per tree per class (from 0.0 to 1.0) 
    public double[] sample_rate_per_class = null;
     */

    /* INHERITED: Column sample rate per tree (from 0.0 to 1.0) 
    public double col_sample_rate_per_tree = 1.0;
     */

    /* INHERITED: Relative change of the column sampling rate for every level (from 0.0 to 2.0) 
    public double col_sample_rate_change_per_level = 1.0;
     */

    /* INHERITED: Score the model after every so many trees. Disabled if set to 0. 
    public int score_tree_interval = 0;
     */

    /* INHERITED: Minimum relative improvement in squared error reduction for a split to happen 
    public double min_split_improvement = 0.0;
     */

    /* INHERITED: What type of histogram to use for finding optimal split points 
    public TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type = TreeSharedTreeModelSharedTreeParametersHistogramType.AUTO;
     */

    /* INHERITED: Destination id for this model; auto-generated if not specified 
    public ModelKeyV3 model_id = null;
     */

    /* INHERITED: Training frame 
    public FrameKeyV3 training_frame = null;
     */

    /* INHERITED: Validation frame 
    public FrameKeyV3 validation_frame = null;
     */

    /* INHERITED: Number of folds for N-fold cross-validation 
    public int nfolds = 0;
     */

    /* INHERITED: Keep cross-validation model predictions 
    public boolean keep_cross_validation_predictions = false;
     */

    /* INHERITED: Keep cross-validation fold assignment 
    public boolean keep_cross_validation_fold_assignment = false;
     */

    /* INHERITED: Allow parallel training of cross-validation models 
    public boolean parallelize_cross_validation = true;
     */

    /* INHERITED: Response column 
    public ColSpecifierV3 response_column = null;
     */

    /* INHERITED: Column with observation weights 
    public ColSpecifierV3 weights_column = null;
     */

    /* INHERITED: Offset column 
    public ColSpecifierV3 offset_column = null;
     */

    /* INHERITED: Column with cross-validation fold index assignment per observation 
    public ColSpecifierV3 fold_column = null;
     */

    /* INHERITED: Cross-validation fold assignment scheme, if fold_column is not specified 
    public ModelParametersFoldAssignmentScheme fold_assignment = ModelParametersFoldAssignmentScheme.AUTO;
     */

    /* INHERITED: Ignored columns 
    public String[] ignored_columns = null;
     */

    /* INHERITED: Ignore constant columns 
    public boolean ignore_const_cols = true;
     */

    /* INHERITED: Whether to score during each iteration of model training 
    public boolean score_each_iteration = false;
     */

    /* INHERITED: Model checkpoint to resume training with 
    public ModelKeyV3 checkpoint = null;
     */

    /* INHERITED: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) 
    public int stopping_rounds = 0;
     */

    /* INHERITED: Maximum allowed runtime in seconds for model training. Use 0 to disable. 
    public double max_runtime_secs = 0.0;
     */

    /* INHERITED: Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) 
    public ScoreKeeperStoppingMetric stopping_metric = ScoreKeeperStoppingMetric.AUTO;
     */

    /* INHERITED: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) 
    public double stopping_tolerance = 0.001;
     */

    public DRFParametersV3() {
        mtries = -1;
        binomial_double_trees = false;
        balance_classes = false;
        class_sampling_factors = null;
        max_after_balance_size = 5.0f;
        max_confusion_matrix_size = 20;
        max_hit_ratio_k = 0;
        ntrees = 50;
        max_depth = 20;
        min_rows = 1.0;
        nbins = 20;
        nbins_top_level = 1024;
        nbins_cats = 1024;
        r2_stopping = 0.999999;
        seed = -1L;
        build_tree_one_node = false;
        sample_rate = 0.632000029087;
        sample_rate_per_class = null;
        col_sample_rate_per_tree = 1.0;
        col_sample_rate_change_per_level = 1.0;
        score_tree_interval = 0;
        min_split_improvement = 0.0;
        histogram_type = TreeSharedTreeModelSharedTreeParametersHistogramType.AUTO;
        model_id = null;
        training_frame = null;
        validation_frame = null;
        nfolds = 0;
        keep_cross_validation_predictions = false;
        keep_cross_validation_fold_assignment = false;
        parallelize_cross_validation = true;
        response_column = null;
        weights_column = null;
        offset_column = null;
        fold_column = null;
        fold_assignment = ModelParametersFoldAssignmentScheme.AUTO;
        ignored_columns = null;
        ignore_const_cols = true;
        score_each_iteration = false;
        checkpoint = null;
        stopping_rounds = 0;
        max_runtime_secs = 0.0;
        stopping_metric = ScoreKeeperStoppingMetric.AUTO;
        stopping_tolerance = 0.001;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
