package water.bindings.pojos;

import com.google.gson.Gson;

public class DownloadDataV3 extends RequestSchema {
    /** Frame to download */
    public FrameKeyV3 frame_id;

    /** Emit double values in a machine readable lossless format with Double.toHexString(). */
    public boolean hex_string;

    /** CSV Stream */
    public String csv;

    /** Suggested Filename */
    public String filename;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public DownloadDataV3() {
        frame_id = null;
        hex_string = false;
        csv = "";
        filename = "";
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
