package water.bindings.pojos;

import com.google.gson.Gson;

public class FindV3 extends RequestSchema {
    /** Frame to search */
    public FrameV3 key;

    /** Column, or null for all */
    public String column;

    /** Starting row for search */
    public long row;

    /** Value to search for; leave blank for a search for missing values */
    public String match;

    /** previous row with matching value, or -1 */
    public long prev;

    /** next row with matching value, or -1 */
    public long next;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public FindV3() {
        key = null;
        column = "";
        row = 0L;
        match = "";
        prev = 0L;
        next = 0L;
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
