package water.bindings.pojos;

import com.google.gson.Gson;

public class GLRMParametersV3 extends ModelParametersSchema {
    /** Transformation of training data */
    public DataInfoTransformType transform;

    /** Rank of matrix approximation */
    public int k;

    /** Numeric loss function */
    public GlrmGLRMModelGLRMParametersLoss loss;

    /** Categorical loss function */
    public GlrmGLRMModelGLRMParametersLoss multi_loss;

    /** Loss function by column (override) */
    public GlrmGLRMModelGLRMParametersLoss[] loss_by_col;

    /** Loss function by column index (override) */
    public int[] loss_by_col_idx;

    /** Length of period (only used with periodic loss function) */
    public int period;

    /** Regularization function for X matrix */
    public GlrmGLRMModelGLRMParametersRegularizer regularization_x;

    /** Regularization function for Y matrix */
    public GlrmGLRMModelGLRMParametersRegularizer regularization_y;

    /** Regularization weight on X matrix */
    public double gamma_x;

    /** Regularization weight on Y matrix */
    public double gamma_y;

    /** Maximum number of iterations */
    public int max_iterations;

    /** Maximum number of updates */
    public int max_updates;

    /** Initial step size */
    public double init_step_size;

    /** Minimum step size */
    public double min_step_size;

    /** RNG seed for initialization */
    public long seed;

    /** Initialization mode */
    public GlrmGLRMInitialization init;

    /** Method for computing SVD during initialization (Caution: Power and Randomized are currently experimental and unstable) */
    public SvdSVDModelSVDParametersMethod svd_method;

    /** User-specified initial Y */
    public FrameKeyV3 user_y;

    /** User-specified initial X */
    public FrameKeyV3 user_x;

    /** Frame key to save resulting X */
    public String loading_name;

    /** Expand categorical columns in user-specified initial Y */
    public boolean expand_user_y;

    /** Reconstruct original training data by reversing transform */
    public boolean impute_original;

    /** Recover singular values and eigenvectors of XY */
    public boolean recover_svd;

    /* INHERITED: Destination id for this model; auto-generated if not specified 
    public ModelKeyV3 model_id = null;
     */

    /* INHERITED: Training frame 
    public FrameKeyV3 training_frame = null;
     */

    /* INHERITED: Validation frame 
    public FrameKeyV3 validation_frame = null;
     */

    /* INHERITED: Number of folds for N-fold cross-validation 
    public int nfolds = 0;
     */

    /* INHERITED: Keep cross-validation model predictions 
    public boolean keep_cross_validation_predictions = false;
     */

    /* INHERITED: Keep cross-validation fold assignment 
    public boolean keep_cross_validation_fold_assignment = false;
     */

    /* INHERITED: Allow parallel training of cross-validation models 
    public boolean parallelize_cross_validation = true;
     */

    /* INHERITED: Response column 
    public ColSpecifierV3 response_column = null;
     */

    /* INHERITED: Column with observation weights 
    public ColSpecifierV3 weights_column = null;
     */

    /* INHERITED: Offset column 
    public ColSpecifierV3 offset_column = null;
     */

    /* INHERITED: Column with cross-validation fold index assignment per observation 
    public ColSpecifierV3 fold_column = null;
     */

    /* INHERITED: Cross-validation fold assignment scheme, if fold_column is not specified 
    public ModelParametersFoldAssignmentScheme fold_assignment = ModelParametersFoldAssignmentScheme.AUTO;
     */

    /* INHERITED: Ignored columns 
    public String[] ignored_columns = null;
     */

    /* INHERITED: Ignore constant columns 
    public boolean ignore_const_cols = true;
     */

    /* INHERITED: Whether to score during each iteration of model training 
    public boolean score_each_iteration = false;
     */

    /* INHERITED: Model checkpoint to resume training with 
    public ModelKeyV3 checkpoint = null;
     */

    /* INHERITED: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) 
    public int stopping_rounds = 0;
     */

    /* INHERITED: Maximum allowed runtime in seconds for model training. Use 0 to disable. 
    public double max_runtime_secs = 0.0;
     */

    /* INHERITED: Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) 
    public ScoreKeeperStoppingMetric stopping_metric = ScoreKeeperStoppingMetric.AUTO;
     */

    /* INHERITED: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) 
    public double stopping_tolerance = 0.001;
     */

    public GLRMParametersV3() {
        transform = DataInfoTransformType.NONE;
        k = 1;
        loss = GlrmGLRMModelGLRMParametersLoss.Quadratic;
        multi_loss = GlrmGLRMModelGLRMParametersLoss.Categorical;
        loss_by_col = null;
        loss_by_col_idx = null;
        period = 1;
        regularization_x = GlrmGLRMModelGLRMParametersRegularizer.None;
        regularization_y = GlrmGLRMModelGLRMParametersRegularizer.None;
        gamma_x = 0.0;
        gamma_y = 0.0;
        max_iterations = 1000;
        max_updates = 2000;
        init_step_size = 1.0;
        min_step_size = 0.0001;
        seed = 8440613992221830L;
        init = GlrmGLRMInitialization.PlusPlus;
        svd_method = SvdSVDModelSVDParametersMethod.Randomized;
        user_y = null;
        user_x = null;
        loading_name = "";
        expand_user_y = true;
        impute_original = false;
        recover_svd = false;
        model_id = null;
        training_frame = null;
        validation_frame = null;
        nfolds = 0;
        keep_cross_validation_predictions = false;
        keep_cross_validation_fold_assignment = false;
        parallelize_cross_validation = true;
        response_column = null;
        weights_column = null;
        offset_column = null;
        fold_column = null;
        fold_assignment = ModelParametersFoldAssignmentScheme.AUTO;
        ignored_columns = null;
        ignore_const_cols = true;
        score_each_iteration = false;
        checkpoint = null;
        stopping_rounds = 0;
        max_runtime_secs = 0.0;
        stopping_metric = ScoreKeeperStoppingMetric.AUTO;
        stopping_tolerance = 0.001;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
