package water.bindings.pojos;

import com.google.gson.Gson;

public class IOEvent extends EventV3 {
    /** flavor of the recorded io (ice/hdfs/...) */
    public String io_flavor;

    /** node where this io event happened */
    public String node;

    /** data info */
    public String data;

    /* INHERITED: Time when the event was recorded. Format is hh:mm:ss:ms 
    public String date = "15:59:59:999";
     */

    /* INHERITED: Time in nanos 
    public long nanos = -1L;
     */

    /* INHERITED: type of recorded event 
    public ApiTimelineV3EventV3EventType type = ApiTimelineV3EventV3EventType.io;
     */

    public IOEvent() {
        io_flavor = "unknown";
        node = "unknown";
        data = "unknown";
        date = "15:59:59:999";
        nanos = -1L;
        type = ApiTimelineV3EventV3EventType.io;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
