package water.bindings.pojos;

import com.google.gson.Gson;

public class InteractionV3 extends RequestSchema {
    /** destination key */
    public FrameKeyV3 dest;

    /** Input data frame */
    public FrameKeyV3 source_frame;

    /** Factor columns */
    public String[] factor_columns;

    /** Whether to create pairwise quadratic interactions between factors (otherwise create one higher-order interaction). Only applicable if there are 3 or more factors. */
    public boolean pairwise;

    /** Max. number of factor levels in pair-wise interaction terms (if enforced, one extra catch-all factor will be made) */
    public int max_factors;

    /** Min. occurrence threshold for factor levels in pair-wise interaction terms */
    public int min_occurrence;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public InteractionV3() {
        dest = null;
        source_frame = null;
        factor_columns = null;
        pairwise = false;
        max_factors = 100;
        min_occurrence = 1;
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
