package water.bindings.pojos;

import com.google.gson.Gson;

public class IoStatsEntry extends Schema {
    /** Back end type */
    public String backend;

    /** Number of store events */
    public long store_count;

    /** Cumulative stored bytes */
    public long store_bytes;

    /** Number of delete events */
    public long delete_count;

    /** Number of load events */
    public long load_count;

    /** Cumulative loaded bytes */
    public long load_bytes;

    public IoStatsEntry() {
        backend = "";
        store_count = 0L;
        store_bytes = 0L;
        delete_count = 0L;
        load_count = 0L;
        load_bytes = 0L;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
