package water.bindings.pojos;

import com.google.gson.Gson;

public class ModelMetricsBase extends Schema {
    /** The model used for this scoring run. */
    public ModelKeyV3 model;

    /** The checksum for the model used for this scoring run. */
    public long model_checksum;

    /** The frame used for this scoring run. */
    public FrameKeyV3 frame;

    /** The checksum for the frame used for this scoring run. */
    public long frame_checksum;

    /** Optional description for this scoring run (to note out-of-bag, sampled data, etc.) */
    public String description;

    /** The category (e.g., Clustering) for the model used for this scoring run. */
    public ModelCategory model_category;

    /** The time in mS since the epoch for the start of this scoring run. */
    public long scoring_time;

    /** Predictions Frame. */
    public FrameV3 predictions;

    /** The Mean Squared Error of the prediction for this scoring run. */
    public double MSE;

    public ModelMetricsBase() {
        model = null;
        model_checksum = 0L;
        frame = null;
        frame_checksum = 0L;
        description = "";
        model_category = null;
        scoring_time = 0L;
        predictions = null;
        MSE = 0.0;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
