package water.bindings.pojos;

import com.google.gson.Gson;

public class ModelParametersSchema extends Schema {
    /** Destination id for this model; auto-generated if not specified */
    public ModelKeyV3 model_id;

    /** Training frame */
    public FrameKeyV3 training_frame;

    /** Validation frame */
    public FrameKeyV3 validation_frame;

    /** Number of folds for N-fold cross-validation */
    public int nfolds;

    /** Keep cross-validation model predictions */
    public boolean keep_cross_validation_predictions;

    /** Keep cross-validation fold assignment */
    public boolean keep_cross_validation_fold_assignment;

    /** Allow parallel training of cross-validation models */
    public boolean parallelize_cross_validation;

    /** Response column */
    public ColSpecifierV3 response_column;

    /** Column with observation weights */
    public ColSpecifierV3 weights_column;

    /** Offset column */
    public ColSpecifierV3 offset_column;

    /** Column with cross-validation fold index assignment per observation */
    public ColSpecifierV3 fold_column;

    /** Cross-validation fold assignment scheme, if fold_column is not specified */
    public ModelParametersFoldAssignmentScheme fold_assignment;

    /** Ignored columns */
    public String[] ignored_columns;

    /** Ignore constant columns */
    public boolean ignore_const_cols;

    /** Whether to score during each iteration of model training */
    public boolean score_each_iteration;

    /** Model checkpoint to resume training with */
    public ModelKeyV3 checkpoint;

    /** Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) */
    public int stopping_rounds;

    /** Maximum allowed runtime in seconds for model training. Use 0 to disable. */
    public double max_runtime_secs;

    /** Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) */
    public ScoreKeeperStoppingMetric stopping_metric;

    /** Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) */
    public double stopping_tolerance;

    public ModelParametersSchema() {
        model_id = null;
        training_frame = null;
        validation_frame = null;
        nfolds = 0;
        keep_cross_validation_predictions = false;
        keep_cross_validation_fold_assignment = false;
        parallelize_cross_validation = false;
        response_column = null;
        weights_column = null;
        offset_column = null;
        fold_column = null;
        fold_assignment = null;
        ignored_columns = null;
        ignore_const_cols = false;
        score_each_iteration = false;
        checkpoint = null;
        stopping_rounds = 0;
        max_runtime_secs = 0.0;
        stopping_metric = null;
        stopping_tolerance = 0.0;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
