package water.bindings.pojos;

import com.google.gson.Gson;

public class ModelSchemaBase extends Schema {
    /** Model key */
    public ModelKeyV3 model_id;

    /** The algo name for this Model. */
    public String algo;

    /** The pretty algo name for this Model (e.g., Generalized Linear Model, rather than GLM). */
    public String algo_full_name;

    /** The response column name for this Model (if applicable). Is null otherwise. */
    public String response_column_name;

    /** The Model's training frame key */
    public FrameKeyV3 data_frame;

    /** Timestamp for when this model was completed */
    public long timestamp;

    public ModelSchemaBase() {
        model_id = null;
        algo = "";
        algo_full_name = "";
        response_column_name = "";
        data_frame = null;
        timestamp = 0L;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
