package water.bindings.pojos;

import com.google.gson.Gson;

public class NetworkEvent extends EventV3 {
    /** Boolean flag distinguishing between sends (true) and receives(false) */
    public boolean is_send;

    /** network protocol (UDP/TCP) */
    public String protocol;

    /** UDP type (exec,ack, ackack,... */
    public String msg_type;

    /** Sending node */
    public String from;

    /** Receiving node */
    public String to;

    /** Pretty print of the first few bytes of the msg payload. Contains class name for tasks. */
    public String data;

    /* INHERITED: Time when the event was recorded. Format is hh:mm:ss:ms 
    public String date = "";
     */

    /* INHERITED: Time in nanos 
    public long nanos = -1L;
     */

    /* INHERITED: type of recorded event 
    public ApiTimelineV3EventV3EventType type = ApiTimelineV3EventV3EventType.unknown;
     */

    public NetworkEvent() {
        is_send = false;
        protocol = "unknown";
        msg_type = "unknown";
        from = "unknown";
        to = "unknown";
        data = "unknown";
        date = "";
        nanos = -1L;
        type = ApiTimelineV3EventV3EventType.unknown;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
