package water.bindings.pojos;

import com.google.gson.Gson;

public class NetworkTestV3 extends RequestSchema {
    /** Collective broadcast/reduce times in microseconds (for each message size) */
    public double[] microseconds_collective;

    /** Collective bandwidths in Bytes/sec (for each message size, for each node) */
    public double[] bandwidths_collective;

    /** Round-trip times in microseconds (for each message size, for each node) */
    public double[][] microseconds;

    /** Bi-directional bandwidths in Bytes/sec (for each message size, for each node) */
    public double[][] bandwidths;

    /** Nodes */
    public String[] nodes;

    /** NetworkTestResults */
    public TwoDimTableV3 table;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public NetworkTestV3() {
        microseconds_collective = null;
        bandwidths_collective = null;
        microseconds = null;
        bandwidths = null;
        nodes = null;
        table = null;
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
