package water.bindings.pojos;

import com.google.gson.Gson;

public class ParseV3 extends RequestSchema {
    /** Final frame name */
    public FrameKeyV3 destination_frame;

    /** Source frames */
    public FrameKeyV3[] source_frames;

    /** Parser type */
    public ApiParseTypeValuesProvider parse_type;

    /** Field separator */
    public byte separator;

    /** Single Quotes */
    public boolean single_quotes;

    /** Check header: 0 means guess, +1 means 1st line is header not data, -1 means 1st line is data not header */
    public int check_header;

    /** Number of columns */
    public int number_columns;

    /** Column names */
    public String[] column_names;

    /** Value types for columns */
    public String[] column_types;

    /** Domains for categorical columns */
    public String[][] domains;

    /** NA strings for columns */
    public String[][] na_strings;

    /** Size of individual parse tasks */
    public int chunk_size;

    /** Delete input key after parse */
    public boolean delete_on_done;

    /** Block until the parse completes (as opposed to returning early and requiring polling */
    public boolean blocking;

    /** Parse job */
    public JobV3 job;

    /** Rows */
    public long rows;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public ParseV3() {
        destination_frame = null;
        source_frames = null;
        parse_type = null;
        separator = 0;
        single_quotes = false;
        check_header = 0;
        number_columns = 0;
        column_names = null;
        column_types = null;
        domains = null;
        na_strings = null;
        chunk_size = 0;
        delete_on_done = false;
        blocking = false;
        job = null;
        rows = 0L;
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
