package water.bindings.pojos;

import com.google.gson.Gson;

public class RapidsV99 extends RequestSchema {
    /** An Abstract Syntax Tree. */
    public String ast;

    /** Parsing error, if any */
    public String error;

    /** Scalar result */
    public double scalar;

    /** Function result */
    public String funstr;

    /** String result */
    public String string;

    /** Result key */
    public FrameKeyV3 key;

    /** Rows in Frame result */
    public long num_rows;

    /** Columns in Frame result */
    public int num_cols;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public RapidsV99() {
        ast = "";
        error = "";
        scalar = 0.0;
        funstr = "";
        string = "";
        key = null;
        num_rows = 0L;
        num_cols = 0;
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
