package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Assembly {
    /** Generate a Java POJO from the Assembly */
    @GET("/99/Assembly.java/{assembly_id}/{pojo_name}")
    Call<AssemblyV99> toJava(@Path("assembly_id") String assembly_id,
                             @Path("pojo_name") String pojo_name);

    /** Fit an assembly to an input frame */
    @FormUrlEncoded
    @POST("/99/Assembly")
    Call<AssemblyV99> fit(@Field("steps") String[] steps,
                          @Field("frame") String frame,
                          @Field("pojo_name") String pojo_name,
                          @Field("assembly_id") String assembly_id,
                          @Field("result") String result,
                          @Field("assembly") String assembly,
                          @Field("_exclude_fields") String _exclude_fields);
}
