package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Frames {
    /** Export a Frame to the given path with optional overwrite. */
    @GET("/3/Frames/{frame_id}/export/{path}/overwrite/{force}")
    Call<FramesV3> export(@Path("frame_id") String frame_id,
                          @Path("path") String path,
                          @Path("force") boolean force);

    /** Export a Frame to the given path with optional overwrite. */
    @FormUrlEncoded
    @POST("/3/Frames/{frame_id}/export")
    Call<FramesV3> export(@Path("frame_id") String frame_id,
                          @Field("column") String column,
                          @Field("row_offset") long row_offset,
                          @Field("row_count") int row_count,
                          @Field("column_offset") int column_offset,
                          @Field("column_count") int column_count,
                          @Field("find_compatible_models") boolean find_compatible_models,
                          @Field("path") String path,
                          @Field("force") boolean force,
                          @Field("_exclude_fields") String _exclude_fields);

    /** Return the summary metrics for a column, e.g. mins, maxes, mean, sigma, percentiles, etc. */
    @GET("/3/Frames/{frame_id}/columns/{column}/summary")
    Call<FramesV3> columnSummary(@Path("frame_id") String frame_id,
                                 @Path("column") String column);

    /** Return the domains for the specified column. "null" if the column is not a categorical. */
    @GET("/3/Frames/{frame_id}/columns/{column}/domain")
    Call<FramesV3> columnDomain(@Path("frame_id") String frame_id,
                                @Path("column") String column);

    /** Return the specified column from a Frame. */
    @GET("/3/Frames/{frame_id}/columns/{column}")
    Call<FramesV3> column(@Path("frame_id") String frame_id,
                          @Path("column") String column);

    /** Return all the columns from a Frame. */
    @GET("/3/Frames/{frame_id}/columns")
    Call<FramesV3> columns(@Path("frame_id") String frame_id);

    /** Return a Frame, including the histograms, after forcing computation of rollups. */
    @GET("/3/Frames/{frame_id}/summary")
    Call<FramesV3> summary(@Path("frame_id") String frame_id);

    /** Return the specified Frame. */
    @GET("/3/Frames/{frame_id}")
    Call<FramesV3> fetch(@Path("frame_id") String frame_id);

    /** Return all Frames in the H2O distributed K/V store. */
    @GET("/3/Frames")
    Call<FramesV3> list();

    /** Delete the specified Frame from the H2O distributed K/V store. */
    @DELETE("/3/Frames/{frame_id}")
    Call<FramesV3> delete(@Path("frame_id") String frame_id);

    /** Delete all Frames from the H2O distributed K/V store. */
    @DELETE("/3/Frames")
    Call<FramesV3> deleteAll();
}
