package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Grid {
    /** Run grid search for DeepLearning model. */
    @FormUrlEncoded
    @POST("/99/Grid/deeplearning")
    Call<GridSearchSchema> train_deeplearning(@Field("model_id") String model_id,
                                              @Field("training_frame") String training_frame,
                                              @Field("validation_frame") String validation_frame,
                                              @Field("nfolds") int nfolds,
                                              @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                              @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                              @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                              @Field("response_column") String response_column,
                                              @Field("weights_column") String weights_column,
                                              @Field("offset_column") String offset_column,
                                              @Field("fold_column") String fold_column,
                                              @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                              @Field("ignored_columns") String[] ignored_columns,
                                              @Field("ignore_const_cols") boolean ignore_const_cols,
                                              @Field("score_each_iteration") boolean score_each_iteration,
                                              @Field("checkpoint") String checkpoint,
                                              @Field("stopping_rounds") int stopping_rounds,
                                              @Field("max_runtime_secs") double max_runtime_secs,
                                              @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                              @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for GLM model. */
    @FormUrlEncoded
    @POST("/99/Grid/glm")
    Call<GridSearchSchema> train_glm(@Field("model_id") String model_id,
                                     @Field("training_frame") String training_frame,
                                     @Field("validation_frame") String validation_frame,
                                     @Field("nfolds") int nfolds,
                                     @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                     @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                     @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                     @Field("response_column") String response_column,
                                     @Field("weights_column") String weights_column,
                                     @Field("offset_column") String offset_column,
                                     @Field("fold_column") String fold_column,
                                     @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                     @Field("ignored_columns") String[] ignored_columns,
                                     @Field("ignore_const_cols") boolean ignore_const_cols,
                                     @Field("score_each_iteration") boolean score_each_iteration,
                                     @Field("checkpoint") String checkpoint,
                                     @Field("stopping_rounds") int stopping_rounds,
                                     @Field("max_runtime_secs") double max_runtime_secs,
                                     @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                     @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for GLRM model. */
    @FormUrlEncoded
    @POST("/99/Grid/glrm")
    Call<GridSearchSchema> train_glrm(@Field("model_id") String model_id,
                                      @Field("training_frame") String training_frame,
                                      @Field("validation_frame") String validation_frame,
                                      @Field("nfolds") int nfolds,
                                      @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                      @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                      @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                      @Field("response_column") String response_column,
                                      @Field("weights_column") String weights_column,
                                      @Field("offset_column") String offset_column,
                                      @Field("fold_column") String fold_column,
                                      @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                      @Field("ignored_columns") String[] ignored_columns,
                                      @Field("ignore_const_cols") boolean ignore_const_cols,
                                      @Field("score_each_iteration") boolean score_each_iteration,
                                      @Field("checkpoint") String checkpoint,
                                      @Field("stopping_rounds") int stopping_rounds,
                                      @Field("max_runtime_secs") double max_runtime_secs,
                                      @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                      @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for KMeans model. */
    @FormUrlEncoded
    @POST("/99/Grid/kmeans")
    Call<GridSearchSchema> train_kmeans(@Field("model_id") String model_id,
                                        @Field("training_frame") String training_frame,
                                        @Field("validation_frame") String validation_frame,
                                        @Field("nfolds") int nfolds,
                                        @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                        @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                        @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                        @Field("response_column") String response_column,
                                        @Field("weights_column") String weights_column,
                                        @Field("offset_column") String offset_column,
                                        @Field("fold_column") String fold_column,
                                        @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                        @Field("ignored_columns") String[] ignored_columns,
                                        @Field("ignore_const_cols") boolean ignore_const_cols,
                                        @Field("score_each_iteration") boolean score_each_iteration,
                                        @Field("checkpoint") String checkpoint,
                                        @Field("stopping_rounds") int stopping_rounds,
                                        @Field("max_runtime_secs") double max_runtime_secs,
                                        @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                        @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for NaiveBayes model. */
    @FormUrlEncoded
    @POST("/99/Grid/naivebayes")
    Call<GridSearchSchema> train_naivebayes(@Field("model_id") String model_id,
                                            @Field("training_frame") String training_frame,
                                            @Field("validation_frame") String validation_frame,
                                            @Field("nfolds") int nfolds,
                                            @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                            @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                            @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                            @Field("response_column") String response_column,
                                            @Field("weights_column") String weights_column,
                                            @Field("offset_column") String offset_column,
                                            @Field("fold_column") String fold_column,
                                            @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                            @Field("ignored_columns") String[] ignored_columns,
                                            @Field("ignore_const_cols") boolean ignore_const_cols,
                                            @Field("score_each_iteration") boolean score_each_iteration,
                                            @Field("checkpoint") String checkpoint,
                                            @Field("stopping_rounds") int stopping_rounds,
                                            @Field("max_runtime_secs") double max_runtime_secs,
                                            @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                            @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for PCA model. */
    @FormUrlEncoded
    @POST("/99/Grid/pca")
    Call<GridSearchSchema> train_pca(@Field("model_id") String model_id,
                                     @Field("training_frame") String training_frame,
                                     @Field("validation_frame") String validation_frame,
                                     @Field("nfolds") int nfolds,
                                     @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                     @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                     @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                     @Field("response_column") String response_column,
                                     @Field("weights_column") String weights_column,
                                     @Field("offset_column") String offset_column,
                                     @Field("fold_column") String fold_column,
                                     @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                     @Field("ignored_columns") String[] ignored_columns,
                                     @Field("ignore_const_cols") boolean ignore_const_cols,
                                     @Field("score_each_iteration") boolean score_each_iteration,
                                     @Field("checkpoint") String checkpoint,
                                     @Field("stopping_rounds") int stopping_rounds,
                                     @Field("max_runtime_secs") double max_runtime_secs,
                                     @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                     @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for SVD model. */
    @FormUrlEncoded
    @POST("/99/Grid/svd")
    Call<GridSearchSchema> train_svd(@Field("model_id") String model_id,
                                     @Field("training_frame") String training_frame,
                                     @Field("validation_frame") String validation_frame,
                                     @Field("nfolds") int nfolds,
                                     @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                     @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                     @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                     @Field("response_column") String response_column,
                                     @Field("weights_column") String weights_column,
                                     @Field("offset_column") String offset_column,
                                     @Field("fold_column") String fold_column,
                                     @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                     @Field("ignored_columns") String[] ignored_columns,
                                     @Field("ignore_const_cols") boolean ignore_const_cols,
                                     @Field("score_each_iteration") boolean score_each_iteration,
                                     @Field("checkpoint") String checkpoint,
                                     @Field("stopping_rounds") int stopping_rounds,
                                     @Field("max_runtime_secs") double max_runtime_secs,
                                     @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                     @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for DRF model. */
    @FormUrlEncoded
    @POST("/99/Grid/drf")
    Call<GridSearchSchema> train_drf(@Field("model_id") String model_id,
                                     @Field("training_frame") String training_frame,
                                     @Field("validation_frame") String validation_frame,
                                     @Field("nfolds") int nfolds,
                                     @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                     @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                     @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                     @Field("response_column") String response_column,
                                     @Field("weights_column") String weights_column,
                                     @Field("offset_column") String offset_column,
                                     @Field("fold_column") String fold_column,
                                     @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                     @Field("ignored_columns") String[] ignored_columns,
                                     @Field("ignore_const_cols") boolean ignore_const_cols,
                                     @Field("score_each_iteration") boolean score_each_iteration,
                                     @Field("checkpoint") String checkpoint,
                                     @Field("stopping_rounds") int stopping_rounds,
                                     @Field("max_runtime_secs") double max_runtime_secs,
                                     @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                     @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for GBM model. */
    @FormUrlEncoded
    @POST("/99/Grid/gbm")
    Call<GridSearchSchema> train_gbm(@Field("model_id") String model_id,
                                     @Field("training_frame") String training_frame,
                                     @Field("validation_frame") String validation_frame,
                                     @Field("nfolds") int nfolds,
                                     @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                     @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                     @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                     @Field("response_column") String response_column,
                                     @Field("weights_column") String weights_column,
                                     @Field("offset_column") String offset_column,
                                     @Field("fold_column") String fold_column,
                                     @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                     @Field("ignored_columns") String[] ignored_columns,
                                     @Field("ignore_const_cols") boolean ignore_const_cols,
                                     @Field("score_each_iteration") boolean score_each_iteration,
                                     @Field("checkpoint") String checkpoint,
                                     @Field("stopping_rounds") int stopping_rounds,
                                     @Field("max_runtime_secs") double max_runtime_secs,
                                     @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                     @Field("stopping_tolerance") double stopping_tolerance);

    /** Run grid search for Aggregator model. */
    @FormUrlEncoded
    @POST("/99/Grid/aggregator")
    Call<GridSearchSchema> train_aggregator(@Field("model_id") String model_id,
                                            @Field("training_frame") String training_frame,
                                            @Field("validation_frame") String validation_frame,
                                            @Field("nfolds") int nfolds,
                                            @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
                                            @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
                                            @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
                                            @Field("response_column") String response_column,
                                            @Field("weights_column") String weights_column,
                                            @Field("offset_column") String offset_column,
                                            @Field("fold_column") String fold_column,
                                            @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
                                            @Field("ignored_columns") String[] ignored_columns,
                                            @Field("ignore_const_cols") boolean ignore_const_cols,
                                            @Field("score_each_iteration") boolean score_each_iteration,
                                            @Field("checkpoint") String checkpoint,
                                            @Field("stopping_rounds") int stopping_rounds,
                                            @Field("max_runtime_secs") double max_runtime_secs,
                                            @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
                                            @Field("stopping_tolerance") double stopping_tolerance);
}
