package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface ImportSQLTable {
    /** Import SQL table into an H2O Frame. */
    @FormUrlEncoded
    @POST("/99/ImportSQLTable")
    Call<JobV3> importSQLTable(@Field("connection_url") String connection_url,
                               @Field("table") String table,
                               @Field("select_query") String select_query,
                               @Field("username") String username,
                               @Field("password") String password,
                               @Field("columns") String columns,
                               @Field("optimize") boolean optimize,
                               @Field("_exclude_fields") String _exclude_fields);
}
