package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface ModelMetrics {
    /** Return the saved scoring metrics for the specified Model and Frame. */
    @GET("/3/ModelMetrics/models/{model}/frames/{frame}")
    Call<ModelMetricsListSchemaV3> fetch(@Path("model") String model,
                                         @Path("frame") String frame);

    /** Return the saved scoring metrics for the specified Model and Frame. */
    @DELETE("/3/ModelMetrics/models/{model}/frames/{frame}")
    Call<ModelMetricsListSchemaV3> delete(@Path("model") String model,
                                          @Path("frame") String frame);

    /** Return the saved scoring metrics for the specified Model. */
    @GET("/3/ModelMetrics/models/{model}")
    Call<ModelMetricsListSchemaV3> fetch(@Path("model") String model);

    /** Return all the saved scoring metrics. */
    @GET("/3/ModelMetrics")
    Call<ModelMetricsListSchemaV3> fetch();

    /** Return the scoring metrics for the specified Frame with the specified Model.  If the Frame has already been scored with the Model then cached results will be returned; otherwise predictions for all rows in the Frame will be generated and the metrics will be returned. */
    @FormUrlEncoded
    @POST("/3/ModelMetrics/models/{model}/frames/{frame}")
    Call<ModelMetricsListSchemaV3> score(@Path("model") String model,
                                         @Path("frame") String frame,
                                         @Field("predictions_frame") String predictions_frame,
                                         @Field("reconstruction_error") boolean reconstruction_error,
                                         @Field("reconstruction_error_per_feature") boolean reconstruction_error_per_feature,
                                         @Field("deep_features_hidden_layer") int deep_features_hidden_layer,
                                         @Field("reconstruct_train") boolean reconstruct_train,
                                         @Field("project_archetypes") boolean project_archetypes,
                                         @Field("reverse_transform") boolean reverse_transform,
                                         @Field("leaf_node_assignment") boolean leaf_node_assignment,
                                         @Field("exemplar_index") int exemplar_index,
                                         @Field("_exclude_fields") String _exclude_fields);
}
