package water.bindings.pojos;

import com.google.gson.Gson;
import java.util.Map;


public class H2OModelBuilderErrorV3 extends H2OErrorV3 {
    /** Model builder parameters. */
    public ModelParametersSchema parameters;

    /** Parameter validation messages */
    public ValidationMessageV3[] messages;

    /** Count of parameter validation errors */
    public int error_count;

    /* INHERITED: Milliseconds since the epoch for the time that this H2OError instance was created.  Generally this is a short time since the underlying error ocurred. 
    public long timestamp = 0L;
     */

    /* INHERITED: Error url 
    public String error_url = "";
     */

    /* INHERITED: Message intended for the end user (a data scientist). 
    public String msg = "";
     */

    /* INHERITED: Potentially more detailed message intended for a developer (e.g. a front end engineer or someone designing a language binding). 
    public String dev_msg = "";
     */

    /* INHERITED: HTTP status code for this error. 
    public int http_status = 0;
     */

    /* INHERITED: Any values that are relevant to reporting or handling this error.  Examples are a key name if the error is on a key, or a field name and object name if it's on a specific field. 
    public Map<String,Object> values = null;
     */

    /* INHERITED: Exception type, if any. 
    public String exception_type = "";
     */

    /* INHERITED: Raw exception message, if any. 
    public String exception_msg = "";
     */

    /* INHERITED: Stacktrace, if any. 
    public String[] stacktrace = null;
     */

    public H2OModelBuilderErrorV3() {
        parameters = null;
        messages = null;
        error_count = 0;
        timestamp = 0L;
        error_url = "";
        msg = "";
        dev_msg = "";
        http_status = 0;
        values = null;
        exception_type = "";
        exception_msg = "";
        stacktrace = null;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
