package water.bindings.pojos;

import com.google.gson.Gson;

public class MetadataBase extends RequestSchema {
    /** Number for specifying an endpoint */
    public int num;

    /** HTTP method (GET, POST, DELETE) if fetching by path */
    public String http_method;

    /** Path for specifying an endpoint */
    public String path;

    /** Class name, for fetching docs for a schema (DEPRECATED) */
    public String classname;

    /** Schema name (e.g., DocsV1), for fetching docs for a schema */
    public String schemaname;

    /** List of endpoint routes */
    public RouteBase[] routes;

    /** List of schemas */
    public SchemaMetadataBase[] schemas;

    /** Table of Contents Markdown */
    public String markdown;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
    public String _exclude_fields = "";
     */

    public MetadataBase() {
        num = 0;
        http_method = "";
        path = "";
        classname = "";
        schemaname = "";
        routes = null;
        schemas = null;
        markdown = "";
        _exclude_fields = "";
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
