package water.bindings.pojos;

import com.google.gson.Gson;

public class RandomDiscreteValueSearchCriteriaV99 extends HyperSpaceSearchCriteriaV99 {
    /** Seed for random number generator; set to a value other than -1 for reproducibility. */
    public long seed;

    /** Maximum number of models to build (optional). */
    public int max_models;

    /** Maximum time to spend building models (optional). */
    public double max_runtime_secs;

    /** Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) */
    public int stopping_rounds;

    /** Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) */
    public ScoreKeeperStoppingMetric stopping_metric;

    /** Relative tolerance for metric-based stopping criterion Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) */
    public double stopping_tolerance;

    /* INHERITED: Hyperparameter space search strategy. 
    public GridHyperSpaceSearchCriteriaStrategy strategy = GridHyperSpaceSearchCriteriaStrategy.RandomDiscrete;
     */

    public RandomDiscreteValueSearchCriteriaV99() {
        seed = -1L;
        max_models = 0;
        max_runtime_secs = 0.0;
        stopping_rounds = 0;
        stopping_metric = ScoreKeeperStoppingMetric.AUTO;
        stopping_tolerance = 0.001;
        strategy = GridHyperSpaceSearchCriteriaStrategy.RandomDiscrete;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
