package water.bindings.pojos;

import com.google.gson.Gson;

public class SharedTreeParametersV3 extends ModelParametersSchema {
    /** Balance training data class counts via over/under-sampling (for imbalanced data). */
    public boolean balance_classes;

    /** Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes. */
    public float[] class_sampling_factors;

    /** Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes. */
    public float max_after_balance_size;

    /** Maximum size (# classes) for confusion matrices to be printed in the Logs */
    public int max_confusion_matrix_size;

    /** Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable) */
    public int max_hit_ratio_k;

    /** Number of trees. */
    public int ntrees;

    /** Maximum tree depth. */
    public int max_depth;

    /** Fewest allowed (weighted) observations in a leaf (in R called 'nodesize'). */
    public double min_rows;

    /** For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the best point */
    public int nbins;

    /** For numerical columns (real/int), build a histogram of (at most) this many bins at the root level, then decrease by factor of two per level */
    public int nbins_top_level;

    /** For categorical columns (factors), build a histogram of this many bins, then split at the best point. Higher values can lead to more overfitting. */
    public int nbins_cats;

    /** Stop making trees when the R^2 metric equals or exceeds this */
    public double r2_stopping;

    /** Seed for pseudo random number generator (if applicable) */
    public long seed;

    /** Run on one node only; no network overhead but fewer cpus used.  Suitable for small datasets. */
    public boolean build_tree_one_node;

    /** Row sample rate per tree (from 0.0 to 1.0) */
    public double sample_rate;

    /** Row sample rate per tree per class (from 0.0 to 1.0) */
    public double[] sample_rate_per_class;

    /** Column sample rate per tree (from 0.0 to 1.0) */
    public double col_sample_rate_per_tree;

    /** Relative change of the column sampling rate for every level (from 0.0 to 2.0) */
    public double col_sample_rate_change_per_level;

    /** Score the model after every so many trees. Disabled if set to 0. */
    public int score_tree_interval;

    /** Minimum relative improvement in squared error reduction for a split to happen */
    public double min_split_improvement;

    /** What type of histogram to use for finding optimal split points */
    public TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type;

    /* INHERITED: Destination id for this model; auto-generated if not specified 
    public ModelKeyV3 model_id = null;
     */

    /* INHERITED: Training frame 
    public FrameKeyV3 training_frame = null;
     */

    /* INHERITED: Validation frame 
    public FrameKeyV3 validation_frame = null;
     */

    /* INHERITED: Number of folds for N-fold cross-validation 
    public int nfolds = 0;
     */

    /* INHERITED: Keep cross-validation model predictions 
    public boolean keep_cross_validation_predictions = false;
     */

    /* INHERITED: Keep cross-validation fold assignment 
    public boolean keep_cross_validation_fold_assignment = false;
     */

    /* INHERITED: Allow parallel training of cross-validation models 
    public boolean parallelize_cross_validation = false;
     */

    /* INHERITED: Response column 
    public ColSpecifierV3 response_column = null;
     */

    /* INHERITED: Column with observation weights 
    public ColSpecifierV3 weights_column = null;
     */

    /* INHERITED: Offset column 
    public ColSpecifierV3 offset_column = null;
     */

    /* INHERITED: Column with cross-validation fold index assignment per observation 
    public ColSpecifierV3 fold_column = null;
     */

    /* INHERITED: Cross-validation fold assignment scheme, if fold_column is not specified 
    public ModelParametersFoldAssignmentScheme fold_assignment = null;
     */

    /* INHERITED: Ignored columns 
    public String[] ignored_columns = null;
     */

    /* INHERITED: Ignore constant columns 
    public boolean ignore_const_cols = false;
     */

    /* INHERITED: Whether to score during each iteration of model training 
    public boolean score_each_iteration = false;
     */

    /* INHERITED: Model checkpoint to resume training with 
    public ModelKeyV3 checkpoint = null;
     */

    /* INHERITED: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) 
    public int stopping_rounds = 0;
     */

    /* INHERITED: Maximum allowed runtime in seconds for model training. Use 0 to disable. 
    public double max_runtime_secs = 0.0;
     */

    /* INHERITED: Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) 
    public ScoreKeeperStoppingMetric stopping_metric = null;
     */

    /* INHERITED: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) 
    public double stopping_tolerance = 0.0;
     */

    public SharedTreeParametersV3() {
        balance_classes = false;
        class_sampling_factors = null;
        max_after_balance_size = 0.0f;
        max_confusion_matrix_size = 0;
        max_hit_ratio_k = 0;
        ntrees = 0;
        max_depth = 0;
        min_rows = 0.0;
        nbins = 0;
        nbins_top_level = 0;
        nbins_cats = 0;
        r2_stopping = 0.0;
        seed = 0L;
        build_tree_one_node = false;
        sample_rate = 0.0;
        sample_rate_per_class = null;
        col_sample_rate_per_tree = 0.0;
        col_sample_rate_change_per_level = 0.0;
        score_tree_interval = 0;
        min_split_improvement = 0.0;
        histogram_type = null;
        model_id = null;
        training_frame = null;
        validation_frame = null;
        nfolds = 0;
        keep_cross_validation_predictions = false;
        keep_cross_validation_fold_assignment = false;
        parallelize_cross_validation = false;
        response_column = null;
        weights_column = null;
        offset_column = null;
        fold_column = null;
        fold_assignment = null;
        ignored_columns = null;
        ignore_const_cols = false;
        score_each_iteration = false;
        checkpoint = null;
        stopping_rounds = 0;
        max_runtime_secs = 0.0;
        stopping_metric = null;
        stopping_tolerance = 0.0;
    }

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
