package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Models {
    /** Return the specified Model from the H2O distributed K/V store, optionally with the list of compatible Frames. */
    @GET("/3/Models/{model_id}")
    Call<ModelsV3> fetch(@Path("model_id") String model_id);

    /** Return all Models from the H2O distributed K/V store. */
    @GET("/3/Models")
    Call<ModelsV3> list();

    /** Delete the specified Model from the H2O distributed K/V store. */
    @DELETE("/3/Models/{model_id}")
    Call<ModelsV3> delete(@Path("model_id") String model_id);

    /** Delete all Models from the H2O distributed K/V store. */
    @DELETE("/3/Models")
    Call<ModelsV3> deleteAll();

    /** Return potentially abridged model suitable for viewing in a browser (currently only used for java model code). */
    @GET("/3/Models.java/{model_id}/preview")
    Call<StreamingSchema> fetchPreview(@Path("model_id") String model_id);

    /** Return the stream containing model implementation in Java code. */
    @GET("/3/Models.java/{model_id}")
    Call<StreamingSchema> fetchJavaCode(@Path("model_id") String model_id);

    /** Import given binary model into H2O. */
    @FormUrlEncoded
    @POST("/99/Models.bin/{model_id}")
    Call<ModelsV3> importModel(@Path("model_id") String model_id,
                               @Field("dir") String dir,
                               @Field("force") boolean force,
                               @Field("_exclude_fields") String _exclude_fields);

    /** Export given model. */
    @GET("/99/Models.bin/{model_id}")
    Call<ModelExportV3> exportModel(@Path("model_id") String model_id);
}
