package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface NodePersistentStorage {
    /** Return true or false. */
    @GET("/3/NodePersistentStorage/categories/{category}/names/{name}/exists")
    Call<NodePersistentStorageV3> exists(@Path("category") String category,
                                         @Path("name") String name);

    /** Return true or false. */
    @GET("/3/NodePersistentStorage/categories/{category}/exists")
    Call<NodePersistentStorageV3> exists(@Path("category") String category);

    /** Return true or false. */
    @GET("/3/NodePersistentStorage/configured")
    Call<NodePersistentStorageV3> configured();

    /** Store a named value. */
    @FormUrlEncoded
    @POST("/3/NodePersistentStorage/{category}/{name}")
    Call<NodePersistentStorageV3> put_with_name(@Path("category") String category,
                                                @Path("name") String name,
                                                @Field("value") String value,
                                                @Field("_exclude_fields") String _exclude_fields);

    /** Return value for a given name. */
    @GET("/3/NodePersistentStorage/{category}/{name}")
    Call<NodePersistentStorageV3> get_as_string(@Path("category") String category,
                                                @Path("name") String name);

    /** Delete a key. */
    @DELETE("/3/NodePersistentStorage/{category}/{name}")
    Call<NodePersistentStorageV3> delete(@Path("category") String category,
                                         @Path("name") String name);

    /** Store a value. */
    @FormUrlEncoded
    @POST("/3/NodePersistentStorage/{category}")
    Call<NodePersistentStorageV3> put(@Path("category") String category,
                                      @Field("name") String name,
                                      @Field("value") String value,
                                      @Field("_exclude_fields") String _exclude_fields);

    /** Return all keys stored for a given category. */
    @GET("/3/NodePersistentStorage/{category}")
    Call<NodePersistentStorageV3> list(@Path("category") String category);
}
