/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty8;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.RequestAuthExtension;
import water.webserver.iface.WebServer;
import water.webserver.jetty8.Jetty8Helper;

class Jetty8ServerAdapter
implements WebServer {
    private final Jetty8Helper helper;
    private final H2OHttpView h2oHttpView;
    private Server jettyServer;

    private Jetty8ServerAdapter(Jetty8Helper helper, H2OHttpView h2oHttpView) {
        this.helper = helper;
        this.h2oHttpView = h2oHttpView;
    }

    static WebServer create(H2OHttpView h2oHttpView) {
        Jetty8Helper helper = new Jetty8Helper(h2oHttpView);
        return new Jetty8ServerAdapter(helper, h2oHttpView);
    }

    public void start(String ip, int port) throws IOException {
        this.jettyServer = this.helper.createJettyServer(ip, port);
        HandlerWrapper handlerWrapper = this.helper.authWrapper(this.jettyServer);
        ServletContextHandler context = this.helper.createServletContextHandler();
        this.registerHandlers(handlerWrapper, context);
        try {
            this.jettyServer.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void stop() throws IOException {
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private void registerHandlers(HandlerWrapper handlerWrapper, ServletContextHandler context) {
        for (Map.Entry entry : this.h2oHttpView.getServlets().entrySet()) {
            context.addServlet((Class)entry.getValue(), (String)entry.getKey());
        }
        ArrayList<Object> extHandlers = new ArrayList<Object>();
        extHandlers.add(this.helper.authenticationHandler());
        Collection authExtensions = this.h2oHttpView.getAuthExtensions();
        for (final RequestAuthExtension requestAuthExtension : authExtensions) {
            extHandlers.add(new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    if (requestAuthExtension.handle(target, request, response)) {
                        baseRequest.setHandled(true);
                    }
                }
            });
        }
        extHandlers.add(context);
        HandlerCollection authHandlers = new HandlerCollection();
        authHandlers.setHandlers(extHandlers.toArray(new Handler[0]));
        LoginHandler loginHandler = new LoginHandler();
        loginHandler.setHandler((Handler)authHandlers);
        HandlerCollection hc = new HandlerCollection();
        hc.setHandlers(new Handler[]{new GateHandler(), loginHandler});
        handlerWrapper.setHandler((Handler)hc);
    }

    private class GateHandler
    extends AbstractHandler {
        private GateHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            boolean handled = Jetty8ServerAdapter.this.h2oHttpView.gateHandler(request, response);
            if (handled) {
                baseRequest.setHandled(true);
            }
        }
    }

    private class LoginHandler
    extends HandlerWrapper {
        private LoginHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            boolean handled = Jetty8ServerAdapter.this.h2oHttpView.loginHandler(target, request, response);
            if (handled) {
                baseRequest.setHandled(true);
            } else {
                super.handle(target, baseRequest, request, response);
            }
        }
    }
}

