/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty8;

import ai.h2o.org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.plus.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SpnegoLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import water.webserver.iface.H2OHttpConfig;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.LoginType;
import water.webserver.jetty8.Jetty8DelegatingAuthenticator;

class Jetty8Helper {
    private final H2OHttpConfig config;
    private final H2OHttpView h2oHttpView;

    Jetty8Helper(H2OHttpView h2oHttpView) {
        this.h2oHttpView = h2oHttpView;
        this.config = h2oHttpView.getConfig();
    }

    Server createJettyServer(String ip, int port) {
        SelectChannelConnector connector;
        String proto;
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Integer.toString(Integer.MAX_VALUE));
        Server jettyServer = new Server();
        if (this.config.ensure_daemon_threads) {
            QueuedThreadPool pool = new QueuedThreadPool();
            pool.setDaemon(true);
            jettyServer.setThreadPool((ThreadPool)pool);
        }
        jettyServer.setSendServerVersion(false);
        if (this.config.jks != null) {
            proto = "https";
            SslContextFactory sslContextFactory = new SslContextFactory(this.config.jks);
            sslContextFactory.setKeyStorePassword(this.config.jks_pass);
            if (this.config.jks_alias != null) {
                sslContextFactory.setCertAlias(this.config.jks_alias);
            }
            connector = new SslSelectChannelConnector(sslContextFactory);
        } else {
            proto = "http";
            connector = new SelectChannelConnector();
        }
        if (ip != null) {
            connector.setHost(ip);
        }
        connector.setPort(port);
        this.configureConnector(proto, (Connector)connector);
        jettyServer.setConnectors(new Connector[]{connector});
        return jettyServer;
    }

    private void configureConnector(String proto, Connector connector) {
        connector.setRequestHeaderSize(Jetty8Helper.getSysPropInt(proto + ".requestHeaderSize", 32768));
        connector.setRequestBufferSize(Jetty8Helper.getSysPropInt(proto + ".requestBufferSize", 32768));
        connector.setResponseHeaderSize(Jetty8Helper.getSysPropInt(proto + ".responseHeaderSize", connector.getResponseHeaderSize()));
        connector.setResponseBufferSize(Jetty8Helper.getSysPropInt(proto + ".responseBufferSize", connector.getResponseBufferSize()));
    }

    private static int getSysPropInt(String suffix, int defaultValue) {
        return Integer.getInteger("sys.ai.h2o." + suffix, defaultValue);
    }

    HandlerWrapper authWrapper(Server jettyServer) {
        Object authenticator;
        Object primaryAuthenticator;
        HashLoginService loginService;
        if (this.config.loginType == LoginType.NONE) {
            return jettyServer;
        }
        switch (this.config.loginType) {
            case HASH: {
                loginService = new HashLoginService("H2O", this.config.login_conf);
                primaryAuthenticator = new BasicAuthenticator();
                break;
            }
            case LDAP: 
            case KERBEROS: 
            case PAM: {
                loginService = new JAASLoginService(this.config.loginType.jaasRealm);
                primaryAuthenticator = new BasicAuthenticator();
                break;
            }
            case SPNEGO: {
                System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                loginService = new SpnegoLoginService(this.config.loginType.jaasRealm, this.config.spnego_properties);
                primaryAuthenticator = new SpnegoAuthenticator();
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.config.loginType + "");
            }
        }
        DefaultIdentityService identityService = new DefaultIdentityService();
        loginService.setIdentityService((IdentityService)identityService);
        jettyServer.addBean((Object)loginService);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        security.setStrict(false);
        constraint.setRoles(new String[]{"*"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        if (this.config.form_auth) {
            FormAuthenticator formAuthenticator = new FormAuthenticator("/login", "/loginError", false);
            authenticator = new Jetty8DelegatingAuthenticator((Authenticator)primaryAuthenticator, formAuthenticator);
        } else {
            authenticator = primaryAuthenticator;
        }
        security.setLoginService((LoginService)loginService);
        security.setAuthenticator((Authenticator)authenticator);
        HashSessionIdManager idManager = new HashSessionIdManager();
        jettyServer.setSessionIdManager((SessionIdManager)idManager);
        HashSessionManager manager = new HashSessionManager();
        if (this.config.session_timeout > 0) {
            manager.setMaxInactiveInterval(this.config.session_timeout * 60);
        }
        SessionHandler sessionHandler = new SessionHandler((SessionManager)manager);
        sessionHandler.setHandler((Handler)security);
        jettyServer.setHandler((Handler)sessionHandler);
        return security;
    }

    ServletContextHandler createServletContextHandler() {
        ServletContextHandler context = new ServletContextHandler(0);
        if (null != this.config.context_path && !this.config.context_path.isEmpty()) {
            context.setContextPath(this.config.context_path);
        } else {
            context.setContextPath("/");
        }
        return context;
    }

    Handler authenticationHandler() {
        return new AuthenticationHandler();
    }

    private class AuthenticationHandler
    extends AbstractHandler {
        private AuthenticationHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            boolean handled = Jetty8Helper.this.h2oHttpView.authenticationHandler(request, response);
            if (handled) {
                baseRequest.setHandled(true);
            }
        }
    }
}

