/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty8;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import water.webserver.iface.H2OWebsocketServlet;
import water.webserver.iface.WebsocketConnection;
import water.webserver.iface.WebsocketHandler;

public class Jetty8WebsocketServlet
extends WebSocketServlet {
    private final H2OWebsocketServlet impl;

    public Jetty8WebsocketServlet(H2OWebsocketServlet impl) {
        this.impl = impl;
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        return new Jetty8WebsocketHandler();
    }

    class Jetty8WebsocketHandler
    implements WebSocket,
    WebSocket.OnTextMessage {
        private Jetty8WebsocketConnection conn;
        private WebsocketHandler handler;

        Jetty8WebsocketHandler() {
        }

        public void onMessage(String data) {
            this.handler.onMessage(data);
        }

        public void onOpen(WebSocket.Connection connection) {
            this.conn = new Jetty8WebsocketConnection(connection);
            this.handler = Jetty8WebsocketServlet.this.impl.onConnect((WebsocketConnection)this.conn);
        }

        public void onClose(int closeCode, String message) {
            this.handler.onClose((WebsocketConnection)this.conn);
            this.handler = null;
            this.conn = null;
        }
    }

    static class Jetty8WebsocketConnection
    implements WebsocketConnection {
        private final WebSocket.Connection connection;

        Jetty8WebsocketConnection(WebSocket.Connection connection) {
            this.connection = connection;
        }

        public void sendMessage(String message) throws IOException {
            this.connection.sendMessage(message);
        }
    }
}

