/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import water.webserver.config.ConnectionConfiguration;
import water.webserver.iface.H2OHttpConfig;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.LoginType;

class Jetty9Helper {
    private final H2OHttpConfig config;
    private final H2OHttpView h2oHttpView;

    Jetty9Helper(H2OHttpView h2oHttpView) {
        this.h2oHttpView = h2oHttpView;
        this.config = h2oHttpView.getConfig();
    }

    Server createJettyServer(String ip, int port) {
        ServerConnector connector;
        Server jettyServer;
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Integer.toString(Integer.MAX_VALUE));
        if (this.config.ensure_daemon_threads) {
            QueuedThreadPool pool = new QueuedThreadPool();
            pool.setDaemon(true);
            jettyServer = new Server((ThreadPool)pool);
            Scheduler s = (Scheduler)jettyServer.getBean(Scheduler.class);
            jettyServer.updateBean((Object)s, (Object)new ScheduledExecutorScheduler(null, true));
        } else {
            jettyServer = new Server();
        }
        boolean isSecured = this.config.jks != null;
        HttpConfiguration httpConfiguration = Jetty9Helper.makeHttpConfiguration(new ConnectionConfiguration(isSecured));
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        if (isSecured) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(this.config.jks);
            sslContextFactory.setKeyStorePassword(this.config.jks_pass);
            if (this.config.jks_alias != null) {
                sslContextFactory.setCertAlias(this.config.jks_alias);
            }
            connector = new ServerConnector(jettyServer, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{httpConnectionFactory}));
        } else {
            connector = new ServerConnector(jettyServer, new ConnectionFactory[]{httpConnectionFactory});
        }
        if (ip != null) {
            connector.setHost(ip);
        }
        connector.setPort(port);
        jettyServer.setConnectors(new Connector[]{connector});
        return jettyServer;
    }

    static HttpConfiguration makeHttpConfiguration(ConnectionConfiguration cfg) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setRequestHeaderSize(cfg.getRequestHeaderSize());
        httpConfiguration.setResponseHeaderSize(cfg.getResponseHeaderSize());
        httpConfiguration.setOutputBufferSize(cfg.getOutputBufferSize(httpConfiguration.getOutputBufferSize()));
        httpConfiguration.setRelativeRedirectAllowed(cfg.isRelativeRedirectAllowed());
        httpConfiguration.setIdleTimeout((long)cfg.getIdleTimeout());
        return httpConfiguration;
    }

    HandlerWrapper authWrapper(Server jettyServer) {
        BasicAuthenticator authenticator;
        HashLoginService loginService;
        if (this.config.loginType == LoginType.NONE) {
            return jettyServer;
        }
        switch (this.config.loginType) {
            case HASH: {
                loginService = new HashLoginService("H2O", this.config.login_conf);
                authenticator = new BasicAuthenticator();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Authentication type '" + this.config.loginType + "' is not supported by this version of H2O.");
            }
        }
        DefaultIdentityService identityService = new DefaultIdentityService();
        loginService.setIdentityService((IdentityService)identityService);
        jettyServer.addBean((Object)loginService);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"**"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        security.setLoginService((LoginService)loginService);
        security.setAuthenticator((Authenticator)authenticator);
        SessionHandler sessionHandler = new SessionHandler();
        if (this.config.session_timeout > 0) {
            sessionHandler.setMaxInactiveInterval(this.config.session_timeout * 60);
        }
        sessionHandler.setHandler((Handler)security);
        jettyServer.setSessionIdManager(sessionHandler.getSessionIdManager());
        jettyServer.setHandler((Handler)sessionHandler);
        return security;
    }

    ServletContextHandler createServletContextHandler() {
        ServletContextHandler context = new ServletContextHandler(0);
        if (null != this.config.context_path && !this.config.context_path.isEmpty()) {
            context.setContextPath(this.config.context_path);
        } else {
            context.setContextPath("/");
        }
        return context;
    }

    Handler authenticationHandler() {
        return new AuthenticationHandler();
    }

    private class AuthenticationHandler
    extends AbstractHandler {
        private AuthenticationHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            boolean handled = Jetty9Helper.this.h2oHttpView.authenticationHandler(request, response);
            if (handled) {
                baseRequest.setHandled(true);
            }
        }
    }
}

