/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.RequestAuthExtension;
import water.webserver.iface.WebServer;
import water.webserver.jetty9.Jetty9Helper;

class Jetty9ServerAdapter
implements WebServer {
    private final Jetty9Helper helper;
    private final H2OHttpView h2oHttpView;
    private Server jettyServer;

    private Jetty9ServerAdapter(Jetty9Helper helper, H2OHttpView h2oHttpView) {
        this.helper = helper;
        this.h2oHttpView = h2oHttpView;
    }

    static WebServer create(H2OHttpView h2oHttpView) {
        Jetty9Helper helper = new Jetty9Helper(h2oHttpView);
        return new Jetty9ServerAdapter(helper, h2oHttpView);
    }

    public void start(String ip, int port) throws IOException {
        this.jettyServer = this.helper.createJettyServer(ip, port);
        HandlerWrapper handlerWrapper = this.helper.authWrapper(this.jettyServer);
        ServletContextHandler context = this.helper.createServletContextHandler();
        this.registerHandlers(handlerWrapper, context);
        try {
            this.jettyServer.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void stop() throws IOException {
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private void registerHandlers(HandlerWrapper handlerWrapper, ServletContextHandler context) {
        for (Map.Entry entry : this.h2oHttpView.getServlets().entrySet()) {
            context.addServlet((Class)entry.getValue(), (String)entry.getKey());
        }
        ArrayList<Object> extHandlers = new ArrayList<Object>();
        extHandlers.add(this.helper.authenticationHandler());
        Collection authExtensions = this.h2oHttpView.getAuthExtensions();
        for (final RequestAuthExtension requestAuthExtension : authExtensions) {
            extHandlers.add(new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    if (requestAuthExtension.handle(target, request, response)) {
                        baseRequest.setHandled(true);
                    }
                }
            });
        }
        extHandlers.add(context);
        HandlerCollection authHandlers = new HandlerCollection();
        authHandlers.setHandlers(extHandlers.toArray(new Handler[0]));
        GateHandler gateHandler = new GateHandler();
        gateHandler.setHandler((Handler)authHandlers);
        handlerWrapper.setHandler((Handler)gateHandler);
    }

    private class GateHandler
    extends HandlerWrapper {
        private GateHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            boolean handled = Jetty9ServerAdapter.this.h2oHttpView.gateHandler(request, response);
            if (handled) {
                baseRequest.setHandled(true);
            } else {
                super.handle(target, baseRequest, request, response);
            }
        }
    }
}

