/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SpnegoLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import water.webserver.iface.H2OHttpConfig;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.LoginType;
import water.webserver.jetty9.Jetty9DelegatingAuthenticator;

class Jetty9Helper {
    private final H2OHttpConfig config;
    private final H2OHttpView h2oHttpView;

    Jetty9Helper(H2OHttpView h2oHttpView) {
        this.h2oHttpView = h2oHttpView;
        this.config = h2oHttpView.getConfig();
    }

    Server createJettyServer(String ip, int port) {
        ServerConnector connector;
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Integer.toString(Integer.MAX_VALUE));
        Server jettyServer = new Server();
        boolean isSecured = this.config.jks != null;
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(isSecured);
        if (isSecured) {
            SslContextFactory sslContextFactory = new SslContextFactory(this.config.jks);
            sslContextFactory.setKeyStorePassword(this.config.jks_pass);
            connector = new ServerConnector(jettyServer, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{httpConnectionFactory}));
        } else {
            connector = new ServerConnector(jettyServer, new ConnectionFactory[]{httpConnectionFactory});
        }
        if (ip != null) {
            connector.setHost(ip);
        }
        connector.setPort(port);
        jettyServer.setConnectors(new Connector[]{connector});
        return jettyServer;
    }

    private HttpConnectionFactory buildHttpConnectionFactory(boolean isSecured) {
        String proto = isSecured ? "https" : "http";
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(true);
        httpConfiguration.setRequestHeaderSize(Jetty9Helper.getSysPropInt(proto + ".requestHeaderSize", 32768));
        httpConfiguration.setResponseHeaderSize(Jetty9Helper.getSysPropInt(proto + ".responseHeaderSize", 32768));
        httpConfiguration.setOutputBufferSize(Jetty9Helper.getSysPropInt(proto + ".responseBufferSize", httpConfiguration.getOutputBufferSize()));
        return new HttpConnectionFactory(httpConfiguration);
    }

    private static int getSysPropInt(String suffix, int defaultValue) {
        return Integer.getInteger("sys.ai.h2o." + suffix, defaultValue);
    }

    HandlerWrapper authWrapper(Server jettyServer) {
        Object authenticator;
        BasicAuthenticator primaryAuthenticator;
        HashLoginService loginService;
        if (this.config.loginType == LoginType.NONE) {
            return jettyServer;
        }
        switch (this.config.loginType) {
            case HASH: {
                loginService = new HashLoginService("H2O", this.config.login_conf);
                primaryAuthenticator = new BasicAuthenticator();
                break;
            }
            case LDAP: 
            case KERBEROS: 
            case PAM: {
                loginService = new JAASLoginService(this.config.loginType.jaasRealm);
                primaryAuthenticator = new BasicAuthenticator();
                break;
            }
            case SPNEGO: {
                loginService = new SpnegoLoginService(this.config.loginType.jaasRealm, this.config.spnego_properties);
                primaryAuthenticator = new SpnegoAuthenticator();
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.config.loginType + "");
            }
        }
        DefaultIdentityService identityService = new DefaultIdentityService();
        loginService.setIdentityService((IdentityService)identityService);
        jettyServer.addBean((Object)loginService);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"**"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        if (this.config.form_auth) {
            FormAuthenticator formAuthenticator = new FormAuthenticator("/login", "/loginError", false);
            authenticator = new Jetty9DelegatingAuthenticator((Authenticator)primaryAuthenticator, formAuthenticator);
        } else {
            authenticator = primaryAuthenticator;
        }
        security.setLoginService((LoginService)loginService);
        security.setAuthenticator((Authenticator)authenticator);
        SessionHandler sessionHandler = new SessionHandler();
        if (this.config.session_timeout > 0) {
            sessionHandler.getSessionManager().setMaxInactiveInterval(this.config.session_timeout * 60);
        }
        sessionHandler.setHandler((Handler)security);
        jettyServer.setSessionIdManager(sessionHandler.getSessionManager().getSessionIdManager());
        jettyServer.setHandler((Handler)sessionHandler);
        return security;
    }

    ServletContextHandler createServletContextHandler() {
        ServletContextHandler context = new ServletContextHandler(0);
        if (null != this.config.context_path && !this.config.context_path.isEmpty()) {
            context.setContextPath(this.config.context_path);
        } else {
            context.setContextPath("/");
        }
        return context;
    }

    Handler authenticationHandler() {
        return new AuthenticationHandler();
    }

    private class AuthenticationHandler
    extends AbstractHandler {
        private AuthenticationHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            boolean handled = Jetty9Helper.this.h2oHttpView.authenticationHandler(request, response);
            if (handled) {
                baseRequest.setHandled(true);
            }
        }
    }
}

