/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import water.webserver.iface.Credentials;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.ProxyServer;
import water.webserver.jetty9.Jetty9Helper;
import water.webserver.jetty9.TransparentProxyServlet;

class Jetty9ProxyServerAdapter
implements ProxyServer {
    private final Jetty9Helper helper;
    private final H2OHttpView h2oHttpView;
    private final Credentials credentials;
    private final String proxyTo;

    private Jetty9ProxyServerAdapter(Jetty9Helper helper, H2OHttpView h2oHttpView, Credentials credentials, String proxyTo) {
        this.helper = helper;
        this.h2oHttpView = h2oHttpView;
        this.credentials = credentials;
        this.proxyTo = proxyTo;
    }

    static ProxyServer create(H2OHttpView h2oHttpView, Credentials credentials, String proxyTo) {
        Jetty9Helper helper = new Jetty9Helper(h2oHttpView);
        return new Jetty9ProxyServerAdapter(helper, h2oHttpView, credentials, proxyTo);
    }

    public void start(String ip, int port) throws IOException {
        Server jettyServer = this.helper.createJettyServer(ip, port);
        HandlerWrapper handlerWrapper = this.helper.authWrapper(jettyServer);
        ServletContextHandler context = this.helper.createServletContextHandler();
        this.registerHandlers(handlerWrapper, context, this.credentials, this.proxyTo);
        try {
            jettyServer.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void registerHandlers(HandlerWrapper handlerWrapper, ServletContextHandler context, Credentials credentials, String proxyTo) {
        ServletHolder proxyServlet = new ServletHolder(TransparentProxyServlet.class);
        proxyServlet.setInitParameter("proxyTo", proxyTo);
        proxyServlet.setInitParameter("Prefix", "/");
        proxyServlet.setInitParameter("BasicAuth", credentials.toBasicAuth());
        context.addServlet(proxyServlet, "/*");
        HandlerCollection authHandlers = new HandlerCollection();
        authHandlers.setHandlers(new Handler[]{this.helper.authenticationHandler(), context});
        ProxyLoginHandler loginHandler = new ProxyLoginHandler();
        loginHandler.setHandler((Handler)authHandlers);
        handlerWrapper.setHandler((Handler)loginHandler);
    }

    private class ProxyLoginHandler
    extends HandlerWrapper {
        private ProxyLoginHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            boolean handled = Jetty9ProxyServerAdapter.this.h2oHttpView.proxyLoginHandler(target, request, response);
            if (handled) {
                baseRequest.setHandled(true);
            } else {
                super.handle(target, baseRequest, request, response);
            }
        }
    }
}

